/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.upstream.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.mqtt.common.facade.LmqQueueStore;
import org.apache.rocketmq.mqtt.common.facade.RetainedPersistManager;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.model.Message;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.model.MqttTopic;
import org.apache.rocketmq.mqtt.common.util.MessageUtil;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.ds.meta.FirstTopicManager;
import org.apache.rocketmq.mqtt.ds.meta.WildcardManager;
import org.apache.rocketmq.mqtt.ds.upstream.UpstreamProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PublishProcessor
implements UpstreamProcessor {
    private static Logger logger = LoggerFactory.getLogger(PublishProcessor.class);
    @Resource
    private LmqQueueStore lmqQueueStore;
    @Resource
    private WildcardManager wildcardManager;
    @Resource
    private FirstTopicManager firstTopicManager;
    @Resource
    RetainedPersistManager retainedPersistManager;

    @Override
    public CompletableFuture<HookResult> process(MqttMessageUpContext context, MqttMessage mqttMessage) {
        MqttPublishMessage mqttPublishMessage = (MqttPublishMessage)mqttMessage;
        boolean isEmpty = false;
        if (ByteBufUtil.getBytes((ByteBuf)mqttPublishMessage.content()).length == 0) {
            mqttPublishMessage = MessageUtil.dealEmptyMessage((MqttPublishMessage)mqttPublishMessage);
            isEmpty = true;
        }
        String msgId = MessageClientIDSetter.createUniqID();
        MqttPublishVariableHeader variableHeader = mqttPublishMessage.variableHeader();
        String originTopic = variableHeader.topicName();
        String pubTopic = TopicUtils.normalizeTopic((String)originTopic);
        MqttTopic mqttTopic = TopicUtils.decode((String)pubTopic);
        this.firstTopicManager.checkFirstTopicIfCreated(mqttTopic.getFirstTopic());
        Set<String> queueNames = this.wildcardManager.matchQueueSetByMsgTopic(pubTopic, context.getNamespace());
        long bornTime = System.currentTimeMillis();
        if (mqttPublishMessage.fixedHeader().isRetain()) {
            MqttPublishMessage retainedMqttPublishMessage = mqttPublishMessage.copy();
            mqttPublishMessage = MessageUtil.removeRetainedFlag((MqttPublishMessage)mqttPublishMessage);
            Message metaMessage = MessageUtil.toMessage((MqttPublishMessage)retainedMqttPublishMessage);
            metaMessage.setMsgId(msgId);
            metaMessage.setBornTimestamp(bornTime);
            metaMessage.setEmpty(isEmpty);
            CompletableFuture storeRetainedFuture = this.retainedPersistManager.storeRetainedMessage(TopicUtils.normalizeTopic((String)metaMessage.getOriginTopic()), metaMessage);
            storeRetainedFuture.whenComplete((res, throwable) -> {
                if (throwable != null) {
                    logger.error("Store topic:{} retained message error.{}", (Object)metaMessage.getOriginTopic(), throwable);
                }
            });
        }
        Message message = MessageUtil.toMessage((MqttPublishMessage)mqttPublishMessage);
        message.setMsgId(msgId);
        message.setBornTimestamp(bornTime);
        message.setEmpty(isEmpty);
        CompletableFuture storeResultFuture = this.lmqQueueStore.putMessage(queueNames, message);
        return storeResultFuture.thenCompose(storeResult -> HookResult.newHookResult((int)200, null, (byte[])JSON.toJSONBytes((Object)storeResult, (SerializerFeature[])new SerializerFeature[0])));
    }
}

