/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.failover.impl;

import com.alipay.sofa.jraft.rhea.client.FutureGroup;
import com.alipay.sofa.jraft.rhea.client.failover.RetryCallable;
import com.alipay.sofa.jraft.rhea.errors.ApiExceptionHelper;
import com.alipay.sofa.jraft.rhea.util.Attachable;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoolFailoverFuture
extends CompletableFuture<Boolean>
implements Attachable<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BoolFailoverFuture.class);
    private final int retriesLeft;
    private final RetryCallable<Boolean> retryCallable;
    private final Object attachments;

    public BoolFailoverFuture(int retriesLeft, RetryCallable<Boolean> retryCallable) {
        this(retriesLeft, retryCallable, null);
    }

    public BoolFailoverFuture(int retriesLeft, RetryCallable<Boolean> retryCallable, Object attachments) {
        this.retriesLeft = retriesLeft;
        this.retryCallable = retryCallable;
        this.attachments = attachments;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (this.retriesLeft > 0 && ApiExceptionHelper.isInvalidEpoch(ex)) {
            LOG.warn("[InvalidEpoch-Failover] cause: {}, [{}] retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
            FutureGroup<Boolean> futureGroup = this.retryCallable.run(ex);
            CompletableFuture.allOf(futureGroup.toArray()).whenComplete((ignored, throwable) -> {
                if (throwable == null) {
                    for (CompletableFuture partOf : futureGroup.futures()) {
                        if (((Boolean)partOf.join()).booleanValue()) continue;
                        super.complete(false);
                        return;
                    }
                    super.complete(true);
                } else {
                    super.completeExceptionally((Throwable)throwable);
                }
            });
            return false;
        }
        if (this.retriesLeft <= 0) {
            LOG.error("[InvalidEpoch-Failover] cause: {}, {} retries left.", (Object)StackTraceUtil.stackTrace(ex), (Object)this.retriesLeft);
        }
        return super.completeExceptionally(ex);
    }

    @Override
    public Object getAttachments() {
        return this.attachments;
    }
}

