/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent;

import com.alipay.sofa.jraft.util.Requires;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityNamedThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AffinityNamedThreadFactory.class);
    private final AtomicInteger id = new AtomicInteger();
    private final String name;
    private final boolean daemon;
    private final int priority;
    private final ThreadGroup group;
    private final AffinityStrategy[] strategies;
    private AffinityLock lastAffinityLock = null;

    public AffinityNamedThreadFactory(String name, AffinityStrategy ... strategies) {
        this(name, false, 5, strategies);
    }

    public AffinityNamedThreadFactory(String name, boolean daemon, AffinityStrategy ... strategies) {
        this(name, daemon, 5, strategies);
    }

    public AffinityNamedThreadFactory(String name, int priority, AffinityStrategy ... strategies) {
        this(name, false, priority, strategies);
    }

    public AffinityNamedThreadFactory(String name, boolean daemon, int priority, AffinityStrategy ... strategies) {
        AffinityStrategy[] affinityStrategyArray;
        this.name = "affinity." + name + " #";
        this.daemon = daemon;
        this.priority = priority;
        SecurityManager s = System.getSecurityManager();
        ThreadGroup threadGroup = this.group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        if (strategies.length == 0) {
            AffinityStrategy[] affinityStrategyArray2 = new AffinityStrategy[1];
            affinityStrategyArray = affinityStrategyArray2;
            affinityStrategyArray2[0] = AffinityStrategies.ANY;
        } else {
            affinityStrategyArray = strategies;
        }
        this.strategies = affinityStrategyArray;
    }

    @Override
    public Thread newThread(Runnable r) {
        Requires.requireNonNull((Object)r, (String)"runnable");
        String name2 = this.name + this.id.getAndIncrement();
        final Runnable r2 = this.wrapRunnable(r);
        Runnable r3 = new Runnable(){

            @Override
            public void run() {
                AffinityLock al = null;
                try {
                    al = AffinityNamedThreadFactory.this.acquireLockBasedOnLast();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    r2.run();
                }
                finally {
                    if (al != null) {
                        try {
                            al.release();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        };
        Thread t = this.wrapThread(this.group, r3, name2);
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.info("Creates new {}.", (Object)t);
        return t;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    protected Runnable wrapRunnable(Runnable r) {
        return r;
    }

    protected Thread wrapThread(ThreadGroup group, Runnable r, String name) {
        return new Thread(group, r, name);
    }

    private synchronized AffinityLock acquireLockBasedOnLast() {
        AffinityLock al;
        AffinityLock affinityLock = al = this.lastAffinityLock == null ? AffinityLock.acquireLock() : this.lastAffinityLock.acquireLock(this.strategies);
        if (al.cpuId() >= 0) {
            if (!al.isBound()) {
                al.bind();
            }
            this.lastAffinityLock = al;
        }
        return al;
    }
}

