/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.hook;

import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.mqtt.common.hook.Hook;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHook;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpstreamHook
implements UpstreamHook {
    public static Logger logger = LoggerFactory.getLogger(AbstractUpstreamHook.class);
    public UpstreamHook nextUpstreamHook;

    @Override
    public void setNextHook(Hook hook) {
        this.nextUpstreamHook = (UpstreamHook)hook;
    }

    @Override
    public Hook getNextHook() {
        return this.nextUpstreamHook;
    }

    @Override
    public CompletableFuture<HookResult> doHook(MqttMessageUpContext context, MqttMessage msg) {
        try {
            CompletableFuture<HookResult> result = this.processMqttMessage(context, msg);
            if (this.nextUpstreamHook == null) {
                return result;
            }
            return result.thenCompose(hookResult -> {
                if (!hookResult.isSuccess()) {
                    CompletableFuture<HookResult> nextHookResult = new CompletableFuture<HookResult>();
                    nextHookResult.complete((HookResult)hookResult);
                    return nextHookResult;
                }
                return this.nextUpstreamHook.doHook(context, msg);
            });
        }
        catch (Throwable t) {
            logger.error("", t);
            CompletableFuture<HookResult> result = new CompletableFuture<HookResult>();
            result.completeExceptionally(t);
            return result;
        }
    }

    public abstract void register();

    public abstract CompletableFuture<HookResult> processMqttMessage(MqttMessageUpContext var1, MqttMessage var2);
}

