/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.model;

import java.util.Objects;

public class QueueOffset {
    private volatile long offset = Long.MAX_VALUE;
    private volatile byte initializingStatus = (byte)-1;

    public QueueOffset() {
    }

    public QueueOffset(long offset) {
        this.offset = offset;
    }

    public boolean isInitialized() {
        return this.offset != Long.MAX_VALUE || this.initializingStatus == 1;
    }

    public boolean isInitializing() {
        return this.initializingStatus == 0;
    }

    public void setInitialized() {
        this.initializingStatus = 1;
    }

    public void setInitializing() {
        this.initializingStatus = 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueOffset that = (QueueOffset)o;
        return this.offset == that.offset && this.initializingStatus == that.initializingStatus;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.initializingStatus);
    }
}

