/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.RingbufferStoreConfigHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.Map;

public final class RingbufferStoreConfigHolderCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private RingbufferStoreConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, RingbufferStoreConfigHolder ringbufferStoreConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, ringbufferStoreConfigHolder.isEnabled());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, ringbufferStoreConfigHolder.getClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, ringbufferStoreConfigHolder.getFactoryClassName(), StringCodec::encode);
        CodecUtil.encodeNullable(clientMessage, ringbufferStoreConfigHolder.getImplementation(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, ringbufferStoreConfigHolder.getFactoryImplementation(), DataCodec::encode);
        MapCodec.encodeNullable(clientMessage, ringbufferStoreConfigHolder.getProperties(), StringCodec::encode, StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static RingbufferStoreConfigHolder decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String className = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        String factoryClassName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        Data implementation = CodecUtil.decodeNullable(iterator2, DataCodec::decode);
        Data factoryImplementation = CodecUtil.decodeNullable(iterator2, DataCodec::decode);
        Map<String, String> properties = MapCodec.decodeNullable(iterator2, StringCodec::decode, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return new RingbufferStoreConfigHolder(className, factoryClassName, implementation, factoryImplementation, properties, enabled);
    }
}

