/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.override.ConfigNode;
import com.hazelcast.internal.util.StringUtil;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class PropertiesToNodeConverter {
    private PropertiesToNodeConverter() {
    }

    static ConfigNode propsToNode(Map<String, String> properties) {
        String rootNode = PropertiesToNodeConverter.findRootNode(properties);
        ConfigNode root = new ConfigNode(rootNode);
        for (Map.Entry<String, String> e : properties.entrySet()) {
            PropertiesToNodeConverter.parseEntry(e.getKey().replaceFirst(rootNode + ".", ""), e.getValue(), root);
        }
        return root;
    }

    private static String findRootNode(Map<String, String> properties) {
        Set rootNodeNames = properties.keySet().stream().map(PropertiesToNodeConverter::firstNodeOf).collect(Collectors.toSet());
        if (rootNodeNames.size() > 1) {
            throw new InvalidConfigurationException("could not determine a root config node name, multiple found: " + rootNodeNames.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        return (String)rootNodeNames.stream().findAny().orElseThrow(() -> new InvalidConfigurationException("No parsed entries found"));
    }

    private static void parseEntry(String key, String value, ConfigNode root) {
        ConfigNode last2 = root;
        for (String s2 : StringUtil.lowerCaseInternal(key).split("\\.")) {
            ConfigNode node = last2.getChildren().get(s2);
            if (node == null) {
                node = new ConfigNode(s2, last2);
                last2.getChildren().put(s2, node);
            }
            last2 = node;
        }
        last2.setValue(value);
    }

    private static String firstNodeOf(String key) {
        int dotIndex = key.indexOf(".");
        return key.substring(0, dotIndex > 0 ? dotIndex : key.length());
    }
}

