/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.AbstractInternalPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionStampUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class PartitionTableView {
    private final InternalPartition[] partitions;
    private long stamp;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PartitionTableView(InternalPartition[] partitions) {
        this.partitions = partitions;
    }

    public long stamp() {
        long s2 = this.stamp;
        if (s2 == 0L) {
            this.stamp = s2 = PartitionStampUtil.calculateStamp(this.partitions);
        }
        return s2;
    }

    public int length() {
        return this.partitions.length;
    }

    public InternalPartition getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public PartitionReplica getReplica(int partitionId, int replicaIndex) {
        InternalPartition partition2 = this.partitions[partitionId];
        return partition2 != null ? partition2.getReplica(replicaIndex) : null;
    }

    public PartitionReplica[] getReplicas(int partitionId) {
        InternalPartition partition2 = this.partitions[partitionId];
        return partition2 != null ? partition2.getReplicasCopy() : new PartitionReplica[7];
    }

    public boolean composedOf(Set<UUID> replicas, Set<UUID> excludedReplicas) {
        for (InternalPartition partition2 : this.partitions) {
            for (PartitionReplica replica : partition2.getReplicasCopy()) {
                if (replica == null || replicas.contains(replica.uuid()) && !excludedReplicas.contains(replica.uuid())) continue;
                return false;
            }
        }
        return true;
    }

    public int distanceOf(PartitionTableView partitionTableView) {
        int distance = 0;
        for (int i = 0; i < this.partitions.length; ++i) {
            distance += this.distanceOf(this.partitions[i], partitionTableView.partitions[i]);
        }
        return distance;
    }

    private int distanceOf(InternalPartition partition1, InternalPartition partition2) {
        int distance = 0;
        for (int i = 0; i < 7; ++i) {
            PartitionReplica replica1 = partition1.getReplica(i);
            PartitionReplica replica2 = partition2.getReplica(i);
            if (replica1 == null) {
                if (replica2 == null) continue;
                distance += 7;
                continue;
            }
            if (replica2 == null || replica1.uuid().equals(replica2.uuid())) continue;
            int replicaIndex2 = this.replicaIndexOfUuid(replica1.uuid(), partition2);
            if (replicaIndex2 == -1) {
                distance += 7;
                continue;
            }
            distance += Math.abs(replicaIndex2 - i);
        }
        return distance;
    }

    private int replicaIndexOfUuid(UUID uuid, InternalPartition partition2) {
        PartitionReplica[] replicas = ((AbstractInternalPartition)partition2).replicas();
        for (int i = 0; i < replicas.length; ++i) {
            if (replicas[i] == null || !replicas[i].uuid().equals(uuid)) continue;
            return i;
        }
        return -1;
    }

    public PartitionReplica[][] toArray(Map<UUID, Address> addressMap) {
        int partitionCount = this.partitions.length;
        PartitionReplica[][] replicas = new PartitionReplica[partitionCount][7];
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            InternalPartition p = this.partitions[partitionId];
            replicas[partitionId] = new PartitionReplica[7];
            for (int index = 0; index < 7; ++index) {
                PartitionReplica replica = p.getReplica(index);
                if (replica == null) continue;
                replicas[partitionId][index] = addressMap.containsKey(replica.uuid()) ? new PartitionReplica(addressMap.get(replica.uuid()), replica.uuid()) : replica;
            }
        }
        return replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionTableView that = (PartitionTableView)o;
        return Arrays.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.partitions);
    }

    public String toString() {
        return "PartitionTableView{partitions=" + Arrays.toString(this.partitions) + ", stamp=" + this.stamp() + '}';
    }
}

