/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.Measurement;
import org.apache.seatunnel.api.common.metrics.MeasurementPredicates;

public final class JobMetrics
implements Serializable {
    private static final JobMetrics EMPTY = new JobMetrics(Collections.emptyMap());
    private static final Collector<Measurement, ?, Map<String, List<Measurement>>> COLLECTOR = Collectors.groupingBy(Measurement::metric);
    private Map<String, List<Measurement>> metrics;

    JobMetrics() {
    }

    private JobMetrics(Map<String, List<Measurement>> metrics) {
        this.metrics = new HashMap<String, List<Measurement>>(metrics);
    }

    public static JobMetrics empty() {
        return EMPTY;
    }

    public static JobMetrics of(Map<String, List<Measurement>> metrics) {
        return new JobMetrics(metrics);
    }

    public Set<String> metrics() {
        return Collections.unmodifiableSet(this.metrics.keySet());
    }

    public List<Measurement> get(String metricName) {
        Objects.requireNonNull(metricName);
        List<Measurement> measurements = this.metrics.get(metricName);
        return measurements == null ? Collections.emptyList() : measurements;
    }

    public JobMetrics filter(String tagName, String tagValue) {
        return this.filter(MeasurementPredicates.tagValueEquals(tagName, tagValue));
    }

    public JobMetrics filter(Predicate<Measurement> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Map<String, List<Measurement>> filteredMetrics = this.metrics.values().stream().flatMap(Collection::stream).filter(predicate).collect(COLLECTOR);
        return new JobMetrics(filteredMetrics);
    }

    public int hashCode() {
        return this.metrics.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Objects.equals(this.metrics, ((JobMetrics)obj).metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.metrics.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(mainEntry -> {
            sb.append((String)mainEntry.getKey()).append(":\n");
            ((List)mainEntry.getValue()).stream().collect(Collectors.groupingBy(m -> {
                String vertex = m.tag("taskName");
                return vertex == null ? "" : vertex;
            })).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> {
                String vertexName = (String)e.getKey();
                sb.append("  ").append(vertexName).append(":\n");
                ((List)e.getValue()).forEach(m -> sb.append("    ").append(m).append("\n"));
            });
        });
        return sb.toString();
    }

    public String toJsonString() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.metrics);
        }
        catch (JsonProcessingException e) {
            ObjectNode objectNode = objectMapper.createObjectNode();
            objectNode.put("err", "serialize JobMetrics err");
            return objectNode.toString();
        }
    }
}

