/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public final class TypesafeConfigUtils {
    private TypesafeConfigUtils() {
    }

    public static Config extractSubConfig(Config source, String prefix, boolean keepPrefix) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ConfigValue> entry : source.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue().unwrapped());
            if (!key.startsWith(prefix)) continue;
            if (keepPrefix) {
                values.put(key, value);
                continue;
            }
            values.put(key.substring(prefix.length()), value);
        }
        return ConfigFactory.parseMap(values);
    }

    public static boolean hasSubConfig(Config source, String prefix) {
        boolean hasConfig = false;
        for (Map.Entry<String, ConfigValue> entry : source.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            hasConfig = true;
            break;
        }
        return hasConfig;
    }

    public static Config extractSubConfigThrowable(Config source, String prefix, boolean keepPrefix) {
        Config config = TypesafeConfigUtils.extractSubConfig(source, prefix, keepPrefix);
        if (config.isEmpty()) {
            throw new ConfigRuntimeException("config is empty");
        }
        return config;
    }

    public static <T> T getConfig(Config config, String configKey, @NonNull T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked @NonNull but is null");
        }
        if (defaultValue.getClass().equals(Long.class)) {
            return (T)(config.hasPath(configKey) ? Long.valueOf(config.getString(configKey)) : defaultValue);
        }
        if (defaultValue.getClass().equals(Integer.class)) {
            return (T)(config.hasPath(configKey) ? Integer.valueOf(config.getString(configKey)) : defaultValue);
        }
        if (defaultValue.getClass().equals(String.class)) {
            return (T)(config.hasPath(configKey) ? config.getString(configKey) : defaultValue);
        }
        if (defaultValue.getClass().equals(Boolean.class)) {
            return (T)(config.hasPath(configKey) ? Boolean.valueOf(config.getString(configKey)) : defaultValue);
        }
        throw new RuntimeException("Unsupported config type, configKey: " + configKey);
    }

    public static List<? extends Config> getConfigList(Config config, String configKey, @NonNull List<? extends Config> defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked @NonNull but is null");
        }
        return config.hasPath(configKey) ? config.getConfigList(configKey) : defaultValue;
    }
}

