/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.common.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.engine.common.config.EngineConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfigSections;
import org.apache.seatunnel.engine.common.config.server.CheckpointConfig;
import org.apache.seatunnel.engine.common.config.server.CheckpointStorageConfig;
import org.apache.seatunnel.engine.common.config.server.ServerConfigOptions;
import org.apache.seatunnel.engine.common.config.server.SlotServiceConfig;
import org.w3c.dom.Node;

public class YamlSeaTunnelDomConfigProcessor
extends AbstractDomConfigProcessor {
    private static final ILogger LOGGER = Logger.getLogger(YamlSeaTunnelDomConfigProcessor.class);
    private final SeaTunnelConfig config;

    YamlSeaTunnelDomConfigProcessor(boolean domLevel3, SeaTunnelConfig config) {
        super(domLevel3);
        this.config = config;
    }

    @Override
    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration.");
            }
            if (this.handleNode(node, nodeName) || SeaTunnelConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleNode(Node node, String name) {
        if (!SeaTunnelConfigSections.ENGINE.isEqual(name)) {
            return true;
        }
        this.parseEngineConfig(node, this.config);
        return false;
    }

    private SlotServiceConfig parseSlotServiceConfig(Node slotServiceNode) {
        SlotServiceConfig slotServiceConfig = new SlotServiceConfig();
        for (Node node : DomConfigHelper.childElements(slotServiceNode)) {
            String name = DomConfigHelper.cleanNodeName(node);
            if (ServerConfigOptions.DYNAMIC_SLOT.key().equals(name)) {
                slotServiceConfig.setDynamicSlot(DomConfigHelper.getBooleanValue(this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.SLOT_NUM.key().equals(name)) {
                slotServiceConfig.setSlotNum(DomConfigHelper.getIntegerValue(ServerConfigOptions.SLOT_NUM.key(), this.getTextContent(node)));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return slotServiceConfig;
    }

    private void parseEngineConfig(Node engineNode, SeaTunnelConfig config) {
        EngineConfig engineConfig = config.getEngineConfig();
        for (Node node : DomConfigHelper.childElements(engineNode)) {
            String name = DomConfigHelper.cleanNodeName(node);
            if (ServerConfigOptions.BACKUP_COUNT.key().equals(name)) {
                engineConfig.setBackupCount(DomConfigHelper.getIntegerValue(ServerConfigOptions.BACKUP_COUNT.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.key().equals(name)) {
                engineConfig.setPrintExecutionInfoInterval(DomConfigHelper.getIntegerValue(ServerConfigOptions.PRINT_EXECUTION_INFO_INTERVAL.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.SLOT_SERVICE.key().equals(name)) {
                engineConfig.setSlotServiceConfig(this.parseSlotServiceConfig(node));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT.key().equals(name)) {
                engineConfig.setCheckpointConfig(this.parseCheckpointConfig(node));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
    }

    private CheckpointConfig parseCheckpointConfig(Node checkpointNode) {
        CheckpointConfig checkpointConfig = new CheckpointConfig();
        for (Node node : DomConfigHelper.childElements(checkpointNode)) {
            String name = DomConfigHelper.cleanNodeName(node);
            if (ServerConfigOptions.CHECKPOINT_INTERVAL.key().equals(name)) {
                checkpointConfig.setCheckpointInterval(DomConfigHelper.getIntegerValue(ServerConfigOptions.CHECKPOINT_INTERVAL.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_TIMEOUT.key().equals(name)) {
                checkpointConfig.setCheckpointTimeout(DomConfigHelper.getIntegerValue(ServerConfigOptions.CHECKPOINT_TIMEOUT.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_MAX_CONCURRENT.key().equals(name)) {
                checkpointConfig.setMaxConcurrentCheckpoints(DomConfigHelper.getIntegerValue(ServerConfigOptions.CHECKPOINT_MAX_CONCURRENT.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_TOLERABLE_FAILURE.key().equals(name)) {
                checkpointConfig.setTolerableFailureCheckpoints(DomConfigHelper.getIntegerValue(ServerConfigOptions.CHECKPOINT_TOLERABLE_FAILURE.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE.key().equals(name)) {
                checkpointConfig.setStorage(this.parseCheckpointStorageConfig(node));
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return checkpointConfig;
    }

    private CheckpointStorageConfig parseCheckpointStorageConfig(Node checkpointStorageConfigNode) {
        CheckpointStorageConfig checkpointStorageConfig = new CheckpointStorageConfig();
        for (Node node : DomConfigHelper.childElements(checkpointStorageConfigNode)) {
            String name = DomConfigHelper.cleanNodeName(node);
            if (ServerConfigOptions.CHECKPOINT_STORAGE_TYPE.key().equals(name)) {
                checkpointStorageConfig.setStorage(this.getTextContent(node));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE_MAX_RETAINED.key().equals(name)) {
                checkpointStorageConfig.setMaxRetainedCheckpoints(DomConfigHelper.getIntegerValue(ServerConfigOptions.CHECKPOINT_STORAGE_MAX_RETAINED.key(), this.getTextContent(node)));
                continue;
            }
            if (ServerConfigOptions.CHECKPOINT_STORAGE_PLUGIN_CONFIG.key().equals(name)) {
                Map<String, String> pluginConfig = this.parseCheckpointPluginConfig(node);
                checkpointStorageConfig.setStoragePluginConfig(pluginConfig);
                continue;
            }
            LOGGER.warning("Unrecognized element: " + name);
        }
        return checkpointStorageConfig;
    }

    private Map<String, String> parseCheckpointPluginConfig(Node checkpointPluginConfigNode) {
        HashMap<String, String> checkpointPluginConfig = new HashMap<String, String>();
        for (Node node : DomConfigHelper.childElements(checkpointPluginConfigNode)) {
            String name = DomConfigHelper.cleanNodeName(node);
            checkpointPluginConfig.put(name, this.getTextContent(node));
        }
        return checkpointPluginConfig;
    }
}

