/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.hazelcast.jet.datamodel.Tuple2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.engine.server.execution.TaskLocation;

public class CheckpointPlan {
    public static final Integer COORDINATOR_INDEX = -1;
    private final int pipelineId;
    private final Set<TaskLocation> pipelineSubtasks;
    private final Set<TaskLocation> startingSubtasks;
    private final Map<Long, Integer> pipelineActions;
    private final Map<TaskLocation, Set<Tuple2<Long, Integer>>> subtaskActions;

    public static Builder builder() {
        return new Builder();
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public Set<TaskLocation> getPipelineSubtasks() {
        return this.pipelineSubtasks;
    }

    public Set<TaskLocation> getStartingSubtasks() {
        return this.startingSubtasks;
    }

    public Map<Long, Integer> getPipelineActions() {
        return this.pipelineActions;
    }

    public Map<TaskLocation, Set<Tuple2<Long, Integer>>> getSubtaskActions() {
        return this.subtaskActions;
    }

    private CheckpointPlan(int pipelineId, Set<TaskLocation> pipelineSubtasks, Set<TaskLocation> startingSubtasks, Map<Long, Integer> pipelineActions, Map<TaskLocation, Set<Tuple2<Long, Integer>>> subtaskActions) {
        this.pipelineId = pipelineId;
        this.pipelineSubtasks = pipelineSubtasks;
        this.startingSubtasks = startingSubtasks;
        this.pipelineActions = pipelineActions;
        this.subtaskActions = subtaskActions;
    }

    public static final class Builder {
        private int pipelineId;
        private final Set<TaskLocation> pipelineSubtasks = new HashSet<TaskLocation>();
        private final Set<TaskLocation> startingSubtasks = new HashSet<TaskLocation>();
        private final Map<Long, Integer> pipelineActions = new HashMap<Long, Integer>();
        private final Map<TaskLocation, Set<Tuple2<Long, Integer>>> subtaskActions = new HashMap<TaskLocation, Set<Tuple2<Long, Integer>>>();

        private Builder() {
        }

        public Builder pipelineSubtasks(Set<TaskLocation> pipelineTaskIds) {
            this.pipelineSubtasks.addAll(pipelineTaskIds);
            return this;
        }

        public Builder startingSubtasks(Set<TaskLocation> startingVertices) {
            this.startingSubtasks.addAll(startingVertices);
            return this;
        }

        public Builder pipelineActions(Map<Long, Integer> pipelineActions) {
            this.pipelineActions.putAll(pipelineActions);
            return this;
        }

        public Builder subtaskActions(Map<TaskLocation, Set<Tuple2<Long, Integer>>> subtaskActions) {
            this.subtaskActions.putAll(subtaskActions);
            return this;
        }

        public Builder pipelineId(int pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public CheckpointPlan build() {
            return new CheckpointPlan(this.pipelineId, this.pipelineSubtasks, this.startingSubtasks, this.pipelineActions, this.subtaskActions);
        }

        public String toString() {
            return "CheckpointPlan.Builder(pipelineId=" + this.pipelineId + ", pipelineSubtasks=" + this.pipelineSubtasks + ", startingSubtasks=" + this.startingSubtasks + ", pipelineActions=" + this.pipelineActions + ", subtaskActions=" + this.subtaskActions + ")";
        }
    }
}

