/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.serializable;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointBarrierTriggerOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointFinishedOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskRestoreOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.NotifyTaskStartOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskAcknowledgeOperation;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;

public final class CheckpointDataSerializerHook
implements DataSerializerHook {
    public static final int CHECKPOINT_BARRIER_TRIGGER_OPERATOR = 1;
    public static final int CHECKPOINT_FINISHED_OPERATOR = 2;
    public static final int TASK_ACK_OPERATOR = 3;
    public static final int TASK_REPORT_STATUS_OPERATOR = 4;
    public static final int NOTIFY_TASK_RESTORE_OPERATOR = 5;
    public static final int NOTIFY_TASK_START_OPERATOR = 6;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.seatunnel.engine.checkpoint", -30006);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 1: {
                    return new CheckpointBarrierTriggerOperation();
                }
                case 2: {
                    return new CheckpointFinishedOperation();
                }
                case 3: {
                    return new TaskAcknowledgeOperation();
                }
                case 4: {
                    return new TaskReportStatusOperation();
                }
                case 5: {
                    return new NotifyTaskRestoreOperation();
                }
                case 6: {
                    return new NotifyTaskStartOperation();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

