/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.cluster.Address;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.common.metrics.Unit;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SinkCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.core.checkpoint.InternalCheckpointListener;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.MetricsContext;
import org.apache.seatunnel.engine.server.task.AbstractTask;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.context.SinkWriterContext;
import org.apache.seatunnel.engine.server.task.flow.ActionFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneInputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.operation.GetTaskGroupAddressOperation;
import org.apache.seatunnel.engine.server.task.operation.checkpoint.BarrierFlowOperation;
import org.apache.seatunnel.engine.server.task.operation.sink.SinkPrepareCommitOperation;
import org.apache.seatunnel.engine.server.task.operation.sink.SinkRegisterOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class SinkFlowLifeCycle<T, CommitInfoT extends Serializable, AggregatedCommitInfoT, StateT>
extends ActionFlowLifeCycle
implements OneInputFlowLifeCycle<Record<?>>,
InternalCheckpointListener {
    private final SinkAction<T, StateT, CommitInfoT, AggregatedCommitInfoT> sinkAction;
    private SinkWriter<T, CommitInfoT, StateT> writer;
    private transient Optional<Serializer<StateT>> writerStateSerializer;
    private final int indexID;
    private final TaskLocation taskLocation;
    private Address committerTaskAddress;
    private final TaskLocation committerTaskLocation;
    private Optional<SinkCommitter<CommitInfoT>> committer;
    private Optional<CommitInfoT> lastCommitInfo;
    private MetricsContext metricsContext;
    private final boolean containAggCommitter;

    public SinkFlowLifeCycle(SinkAction<T, StateT, CommitInfoT, AggregatedCommitInfoT> sinkAction, TaskLocation taskLocation, int indexID, SeaTunnelTask runningTask, TaskLocation committerTaskLocation, boolean containAggCommitter, CompletableFuture<Void> completableFuture, MetricsContext metricsContext) {
        super(sinkAction, runningTask, completableFuture);
        this.sinkAction = sinkAction;
        this.indexID = indexID;
        this.taskLocation = taskLocation;
        this.committerTaskLocation = committerTaskLocation;
        this.containAggCommitter = containAggCommitter;
        this.metricsContext = metricsContext;
    }

    @Override
    public void init() throws Exception {
        this.writerStateSerializer = this.sinkAction.getSink().getWriterStateSerializer();
        this.committer = this.sinkAction.getSink().createCommitter();
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.containAggCommitter) {
            this.committerTaskAddress = this.getCommitterTaskAddress();
        }
        this.registerCommitter();
    }

    private Address getCommitterTaskAddress() throws ExecutionException, InterruptedException {
        return (Address)this.runningTask.getExecutionContext().sendToMaster(new GetTaskGroupAddressOperation(this.committerTaskLocation)).get();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.writer.close();
    }

    private void registerCommitter() {
        if (this.containAggCommitter) {
            this.runningTask.getExecutionContext().sendToMember(new SinkRegisterOperation(this.taskLocation, this.committerTaskLocation), this.committerTaskAddress).join();
        }
    }

    @Override
    public void received(Record<?> record) {
        block13: {
            try {
                if (record.getData() instanceof Barrier) {
                    Barrier barrier = (Barrier)record.getData();
                    if (barrier.prepareClose()) {
                        this.prepareClose = true;
                    }
                    if (barrier.snapshot()) {
                        try {
                            this.lastCommitInfo = this.writer.prepareCommit();
                        }
                        catch (Exception e) {
                            this.writer.abortPrepare();
                            throw e;
                        }
                        List<StateT> states = this.writer.snapshotState(barrier.getId());
                        if (!this.writerStateSerializer.isPresent()) {
                            this.runningTask.addState(barrier, this.sinkAction.getId(), Collections.emptyList());
                        } else {
                            this.runningTask.addState(barrier, this.sinkAction.getId(), AbstractTask.serializeStates(this.writerStateSerializer.get(), states));
                        }
                        if (this.containAggCommitter) {
                            this.lastCommitInfo.ifPresent(commitInfoT -> this.runningTask.getExecutionContext().sendToMember(new SinkPrepareCommitOperation(barrier, this.committerTaskLocation, SerializationUtils.serialize(commitInfoT)), this.committerTaskAddress).join());
                        }
                    } else if (this.containAggCommitter) {
                        this.runningTask.getExecutionContext().sendToMember(new BarrierFlowOperation(barrier, this.committerTaskLocation), this.committerTaskAddress);
                    }
                    this.runningTask.ack(barrier);
                    break block13;
                }
                if (this.prepareClose.booleanValue()) {
                    return;
                }
                this.writer.write(record.getData());
                this.metricsContext.threadSafeQpsMetric("SinkWriteQPS", Unit.COUNT).increment();
                this.metricsContext.threadSafeMetric("SinkWriteCount", Unit.COUNT).increment();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        if (this.committer.isPresent() && this.lastCommitInfo.isPresent()) {
            this.committer.get().commit(Collections.singletonList(this.lastCommitInfo.get()));
        }
    }

    @Override
    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        if (this.committer.isPresent() && this.lastCommitInfo.isPresent()) {
            this.committer.get().abort(Collections.singletonList(this.lastCommitInfo.get()));
        }
    }

    @Override
    public void restoreState(List<ActionSubtaskState> actionStateList) throws Exception {
        List<Object> states = new ArrayList();
        if (this.writerStateSerializer.isPresent()) {
            states = actionStateList.stream().filter(state -> this.writerStateSerializer.isPresent()).map(ActionSubtaskState::getState).flatMap(Collection::stream).map(bytes -> ExceptionUtil.sneaky(() -> this.writerStateSerializer.get().deserialize((byte[])bytes))).collect(Collectors.toList());
        }
        this.writer = states.isEmpty() ? this.sinkAction.getSink().createWriter(new SinkWriterContext(this.indexID)) : this.sinkAction.getSink().restoreWriter(new SinkWriterContext(this.indexID), states);
    }
}

