/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAllPartitionsMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.security.Permission;
import java.util.Map;

public class MapClearMessageTask
extends AbstractMapAllPartitionsMessageTask<String> {
    public MapClearMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        MapOperationProvider operationProvider = this.getOperationProvider((String)this.parameters);
        return operationProvider.createClearOperationFactory((String)this.parameters);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map2) {
        MapService mapService;
        MapContainer mapContainer;
        int clearedTotal = 0;
        for (Object affectedEntries : map2.values()) {
            clearedTotal += ((Integer)affectedEntries).intValue();
        }
        MapService service = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = service.getMapServiceContext();
        if (clearedTotal > 0) {
            Address thisAddress = this.nodeEngine.getThisAddress();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            mapEventPublisher.publishMapEvent(thisAddress, (String)this.parameters, EntryEventType.CLEAR_ALL, clearedTotal);
        }
        if ((mapContainer = (mapService = (MapService)this.getService("hz:impl:mapService")).getMapServiceContext().getMapContainer((String)this.parameters)).getMapConfig().isStatisticsEnabled()) {
            LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
            localMapStatsProvider.getLocalMapStatsImpl((String)this.parameters).incrementOtherOperations();
        }
        return null;
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return MapClearCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapClearCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission((String)this.parameters, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "clear";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

