/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public abstract class Column
implements Serializable {
    private static final long serialVersionUID = -1L;
    protected final String name;
    protected final SeaTunnelDataType<?> dataType;
    protected final Integer columnLength;
    protected final boolean nullable;
    protected final Object defaultValue;
    protected final String comment;

    protected Column(String name, SeaTunnelDataType<?> dataType, Integer columnLength, boolean nullable, Object defaultValue, String comment) {
        this.name = name;
        this.dataType = dataType;
        this.columnLength = columnLength;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.comment = comment;
    }

    public abstract boolean isPhysical();

    public abstract Column copy(SeaTunnelDataType<?> var1);

    public String getName() {
        return this.name;
    }

    public SeaTunnelDataType<?> getDataType() {
        return this.dataType;
    }

    public Integer getColumnLength() {
        return this.columnLength;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        Integer this$columnLength = this.getColumnLength();
        Integer other$columnLength = other.getColumnLength();
        if (this$columnLength == null ? other$columnLength != null : !((Object)this$columnLength).equals(other$columnLength)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SeaTunnelDataType<?> this$dataType = this.getDataType();
        SeaTunnelDataType<?> other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + (this.isNullable() ? 79 : 97);
        Integer $columnLength = this.getColumnLength();
        result2 = result2 * 59 + ($columnLength == null ? 43 : ((Object)$columnLength).hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        SeaTunnelDataType<?> $dataType = this.getDataType();
        result2 = result2 * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result2 = result2 * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $comment = this.getComment();
        result2 = result2 * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result2;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", dataType=" + this.getDataType() + ", columnLength=" + this.getColumnLength() + ", nullable=" + this.isNullable() + ", defaultValue=" + this.getDefaultValue() + ", comment=" + this.getComment() + ")";
    }
}

