/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.MembershipAwareService;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.SeaTunnelHealthMonitor;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.service.slot.DefaultSlotService;
import org.apache.seatunnel.engine.server.service.slot.SlotService;

public class SeaTunnelServer
implements ManagedService,
MembershipAwareService,
LiveOperationsTracker {
    private static final ILogger LOGGER = Logger.getLogger(SeaTunnelServer.class);
    public static final String SERVICE_NAME = "st:impl:seaTunnelServer";
    private NodeEngineImpl nodeEngine;
    private final LiveOperationRegistry liveOperationRegistry;
    private volatile SlotService slotService;
    private TaskExecutionService taskExecutionService;
    private CoordinatorService coordinatorService;
    private ScheduledExecutorService monitorService;
    private SeaTunnelHealthMonitor seaTunnelHealthMonitor;
    private final SeaTunnelConfig seaTunnelConfig;
    private volatile boolean isRunning = true;

    public SeaTunnelServer(@NonNull SeaTunnelConfig seaTunnelConfig) {
        if (seaTunnelConfig == null) {
            throw new NullPointerException("seaTunnelConfig is marked non-null but is null");
        }
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.seaTunnelConfig = seaTunnelConfig;
        LOGGER.info("SeaTunnel server start...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotService getSlotService() {
        if (this.slotService == null) {
            SeaTunnelServer seaTunnelServer = this;
            synchronized (seaTunnelServer) {
                if (this.slotService == null) {
                    DefaultSlotService service = new DefaultSlotService(this.nodeEngine, this.taskExecutionService, this.seaTunnelConfig.getEngineConfig().getSlotServiceConfig());
                    service.init();
                    this.slotService = service;
                }
            }
        }
        return this.slotService;
    }

    @Override
    public void init(NodeEngine engine, Properties hzProperties) {
        this.nodeEngine = (NodeEngineImpl)engine;
        this.taskExecutionService = new TaskExecutionService(this.nodeEngine, this.nodeEngine.getProperties());
        this.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this.taskExecutionService);
        this.taskExecutionService.start();
        this.getSlotService();
        this.coordinatorService = new CoordinatorService(this.nodeEngine, this, this.seaTunnelConfig.getEngineConfig());
        this.monitorService = Executors.newSingleThreadScheduledExecutor();
        this.monitorService.scheduleAtFixedRate(this::printExecutionInfo, 0L, this.seaTunnelConfig.getEngineConfig().getPrintExecutionInfoInterval(), TimeUnit.SECONDS);
        this.seaTunnelHealthMonitor = new SeaTunnelHealthMonitor(((NodeEngineImpl)engine).getNode());
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
        this.isRunning = false;
        if (this.taskExecutionService != null) {
            this.taskExecutionService.shutdown();
        }
        if (this.monitorService != null) {
            this.monitorService.shutdownNow();
        }
        if (this.slotService != null) {
            this.slotService.close();
        }
        if (this.coordinatorService != null) {
            this.coordinatorService.shutdown();
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        try {
            if (this.isMasterNode()) {
                this.getCoordinatorService().memberRemoved(event);
            }
        }
        catch (SeaTunnelEngineException e) {
            LOGGER.severe("Error when handle member removed event", e);
        }
    }

    @Override
    public void populate(LiveOperations liveOperations) {
    }

    public String printMessage(String message) {
        LOGGER.info(this.nodeEngine.getThisAddress() + ":" + message);
        return message;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public CoordinatorService getCoordinatorService() {
        if (this.isMasterNode()) {
            int retryPause;
            String hazelcastInvocationMaxRetry = this.seaTunnelConfig.getHazelcastConfig().getProperty("hazelcast.invocation.max.retry.count");
            int maxRetry = hazelcastInvocationMaxRetry == null ? 500 : Integer.parseInt(hazelcastInvocationMaxRetry) * 2;
            String hazelcastRetryPause = this.seaTunnelConfig.getHazelcastConfig().getProperty("hazelcast.invocation.retry.pause.millis");
            int n = retryPause = hazelcastRetryPause == null ? 500 : Integer.parseInt(hazelcastRetryPause);
            for (int retryCount = 0; this.isMasterNode() && !this.coordinatorService.isCoordinatorActive() && retryCount < maxRetry && this.isRunning; ++retryCount) {
                try {
                    LOGGER.warning("This is master node, waiting the coordinator service init finished");
                    Thread.sleep(retryPause);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.coordinatorService.isCoordinatorActive()) {
                return this.coordinatorService;
            }
            if (!this.isMasterNode()) {
                throw new SeaTunnelEngineException("This is not a master node now.");
            }
            throw new SeaTunnelEngineException("Can not get coordinator service from an active master node.");
        }
        throw new SeaTunnelEngineException("Please don't get coordinator service from an inactive master node");
    }

    public TaskExecutionService getTaskExecutionService() {
        return this.taskExecutionService;
    }

    public boolean taskIsEnded(@NonNull TaskGroupLocation taskGroupLocation) {
        if (taskGroupLocation == null) {
            throw new NullPointerException("taskGroupLocation is marked non-null but is null");
        }
        IMap runningJobState = this.nodeEngine.getHazelcastInstance().getMap("engine_runningJobState");
        Object taskState = runningJobState.get(taskGroupLocation);
        return taskState != null && ((ExecutionState)taskState).isEndState();
    }

    public boolean isMasterNode() {
        try {
            return RetryUtils.retryWithException(() -> this.nodeEngine.getMasterAddress().equals(this.nodeEngine.getThisAddress()), new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof NullPointerException && this.isRunning, 2000L));
        }
        catch (InterruptedException e) {
            LOGGER.info("master node check interrupted");
            return false;
        }
        catch (Exception e) {
            throw new SeaTunnelEngineException("cluster have no master node", e);
        }
    }

    private void printExecutionInfo() {
        this.coordinatorService.printExecutionInfo();
        if (this.coordinatorService.isCoordinatorActive() && this.isMasterNode()) {
            this.coordinatorService.printJobDetailInfo();
        }
    }

    public SeaTunnelHealthMonitor getSeaTunnelHealthMonitor() {
        return this.seaTunnelHealthMonitor;
    }
}

