/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.api.common.metrics.RawJobMetrics;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.metrics.JobMetricsCollector;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;

public class GetTaskGroupMetricsOperation
extends Operation
implements IdentifiedDataSerializable {
    private TaskGroupLocation taskGroupLocation;
    private RawJobMetrics response;

    public GetTaskGroupMetricsOperation() {
    }

    public GetTaskGroupMetricsOperation(TaskGroupLocation taskGroupLocation) {
        this.taskGroupLocation = taskGroupLocation;
    }

    @Override
    public void run() {
        ILogger logger = this.getLogger();
        Address callerAddress = this.getCallerAddress();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!callerAddress.equals(masterAddress)) {
            throw new IllegalStateException("Caller " + callerAddress + " cannot get taskGroupLocation metrics" + this.taskGroupLocation.toString() + " because it is not master. Master is: " + masterAddress);
        }
        JobMetricsCollector metricsRenderer = new JobMetricsCollector(this.taskGroupLocation, nodeEngine.getLocalMember(), logger);
        nodeEngine.getMetricsRegistry().collect(metricsRenderer);
        this.response = metricsRenderer.getMetrics();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.taskGroupLocation);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskGroupLocation = (TaskGroupLocation)in.readObject();
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }
}

