/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.com.fasterxml.jackson.databind.type;

import java.util.Collection;
import java.util.Map;

public enum LogicalType {
    Array,
    Collection,
    Map,
    POJO,
    Untyped,
    Integer,
    Float,
    Boolean,
    Enum,
    Textual,
    Binary,
    DateTime,
    OtherScalar;


    public static LogicalType fromClass(Class<?> raw2, LogicalType defaultIfNotRecognized) {
        if (raw2.isEnum()) {
            return Enum;
        }
        if (raw2.isArray()) {
            if (raw2 == byte[].class) {
                return Binary;
            }
            return Array;
        }
        if (Collection.class.isAssignableFrom(raw2)) {
            return Collection;
        }
        if (Map.class.isAssignableFrom(raw2)) {
            return Map;
        }
        if (raw2 == String.class) {
            return Textual;
        }
        return defaultIfNotRecognized;
    }
}

