/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.console.sink;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(ConsoleSinkWriter.class);
    private final SeaTunnelRowType seaTunnelRowType;
    public final AtomicLong rowCounter = new AtomicLong(0L);
    public SinkWriter.Context context;

    public ConsoleSinkWriter(SeaTunnelRowType seaTunnelRowType, SinkWriter.Context context) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.context = context;
        log.info("output rowType: {}", (Object)this.fieldsInfo(seaTunnelRowType));
    }

    public void write(SeaTunnelRow element) {
        Object[] arr = new String[this.seaTunnelRowType.getTotalFields()];
        SeaTunnelDataType[] fieldTypes = this.seaTunnelRowType.getFieldTypes();
        Object[] fields = element.getFields();
        for (int i = 0; i < fieldTypes.length; ++i) {
            arr[i] = this.fieldToString(fieldTypes[i], fields[i]);
        }
        log.info("subtaskIndex={}  rowIndex={}:  SeaTunnelRow#tableId={} SeaTunnelRow#kind={} : {}", new Object[]{this.context.getIndexOfSubtask(), this.rowCounter.incrementAndGet(), element.getTableId(), element.getRowKind(), StringUtils.join((Object[])arr, (String)", ")});
    }

    public void close() {
    }

    private String fieldsInfo(SeaTunnelRowType seaTunnelRowType) {
        Object[] fieldsInfo = new String[seaTunnelRowType.getTotalFields()];
        for (int i = 0; i < seaTunnelRowType.getTotalFields(); ++i) {
            fieldsInfo[i] = String.format("%s<%s>", seaTunnelRowType.getFieldName(i), seaTunnelRowType.getFieldType(i));
        }
        return StringUtils.join((Object[])fieldsInfo, (String)", ");
    }

    private String fieldToString(SeaTunnelDataType<?> type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.getSqlType()) {
            case ARRAY: 
            case BYTES: {
                ArrayList<String> arrayData = new ArrayList<String>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    arrayData.add(String.valueOf(Array.get(value, i)));
                }
                return ((Object)arrayData).toString();
            }
            case MAP: {
                return JsonUtils.toJsonString((Object)value);
            }
            case ROW: {
                ArrayList<String> rowData = new ArrayList<String>();
                SeaTunnelRowType rowType = (SeaTunnelRowType)type;
                for (int i = 0; i < rowType.getTotalFields(); ++i) {
                    rowData.add(this.fieldToString(rowType.getFieldTypes()[i], ((SeaTunnelRow)value).getField(i)));
                }
                return ((Object)rowData).toString();
            }
        }
        return String.valueOf(value);
    }
}

