---
sidebar_position: 15
---

# Slot分配策略

Slot分配策略是SeaTunnel Engine的一个重要组成部分，它决定了SeaTunnel Engine如何将任务分配到不同的Slot上。Slot分配策略是一个可配置的组件，用户可以根据自己的需求来配置Slot分配策略。

**配置方法：**

设置参数`slot-allocation-strategy`, 可选值有`RANDOM`, `SYSTEM_LOAD`, `SLOT_RATIO`。

例：
```yaml
seatunnel:
  engine:
    slot-service:
      slot-allocation-strategy: RANDOM
...
```

## RANDOM(默认值)

随机分配策略是SeaTunnel Engine默认的Slot分配策略，它将任务随机分配到不同的Slot上。

## SYSTEM_LOAD

系统负载策略是根据系统的负载情况来分配Slot的策略，它会根据系统的负载情况来动态调整Slot的分配。

### 1. **时间权重的设计**
时间权重体现了时间对调度优先级的影响：
- 最近的数据赋予较高权重，历史数据逐渐衰减。
- 采用分布 $4, 2, 2, 1, 1$ 并归一化后，每次统计的时间权重为：
  $$ \text{时间权重比例} = \frac{\text{当前权重}}{10} $$

> 当集群刚启动时，数据不足5条，会单独做归一化，这里计算公式会动态调整，不做赘述。

### 2. **资源利用率计算**
将 CPU 和内存资源的空闲率按照权重进行综合评估：
$$ \text{资源空闲率} = \frac{(1 - \text{CPU利用率}) \cdot \text{CPU权重} + (1 - \text{内存利用率}) \cdot \text{内存权重}}{\text{CPU权重} + \text{内存权重}} $$

- 公式中的 $(1 - \text{CPU利用率})$ 和 $(1 - \text{内存利用率})$ 是空闲率。
- CPU 和内存的权重可根据具体需求调整（如 $0.6$ 和 $0.4$），灵活适应不同场景。

### 3. **时间衰减与调度优先级公式**

引入时间权重衰减后，计算调度优先级的公式为：
$$
\text{综合资源空闲率} = \sum_{i=1}^{5} \left( \frac{(1 - \text{CPU利用率}_i) \cdot \text{CPU权重} + (1 - \text{内存利用率}_i) \cdot \text{内存权重}}{\text{CPU权重} + \text{内存权重}} \cdot \text{时间权重}_i \right)
$$

### 4. **Slot分配的资源空闲率动态调整**
分配多个 Slot 时，考虑到资源状态的实时更新和动态模拟（因为同一任务资源快速分配负载是不会变化）：
- **每个 Slot 使用的资源比** = （1-综合资源空闲率） ÷ 已分配的 Slot 数量
- 分配 Slot 后更新对应节点的空闲率：
  $$ \text{Slot分配后的空闲率} = \text{综合资源空闲率} - \text{每 Slot 使用的资源比} $$
- 默认单个Slot使用10%资源（首次启动无法得知但Slot占用资源，这里默认设置为10%，不设置太低的原因是防止分配过多资源导致该节点负载太高。等下一次监控信息捕获到就会相对准确。）

这种方法属于与计算使得调度更加贴合实际资源使用情况。

### 5. **平衡因子引入**
只通过Slot动态调整更新资源空闲率可能也会存在误差，我们引入基于Slot数量的平衡因子，衡量节点当前负载状态，避免调度资源分配过于集中：
> 该数量可以实时统计到，用来优化调度优先级指标

$$
\text{BalanceFactor}_i = 1 - \frac{S_{\text{used},i}}{S_{\text{total},i}}
$$

- $S_{\text{used},i}$：节点 $i$ 已分配的 Slot 数。
- $S_{\text{total},i}$：节点 $i$ 的 Slot 总数。

通过平衡因子调整调度优先级：
$$
W_i = \alpha \cdot \text{Slot分配后的空闲率}_i + \beta \cdot \text{BalanceFactor}_i
$$

**参数意义**：
- $\alpha$：侧重资源利用率的权重：0.7
- $\beta$：平衡因子的权重，防止单点过载。：0.3

### 6. **动态调整逻辑**
- 定时采集 CPU 和内存利用率，维持最近 5 次的统计数据。
- 同一任务动态更新权重，对旧数据逐步衰减。
- 根据Slot使用，动态平衡。

> 说明：
> 比如我们有两个节点，需要申请10个Slot，A有10个空闲Slot，B有20个空闲Slot，当通过第四步、第五步计算后，10个Slot的权重计算，A节点权重都比B节点权重高。
> 那么我们仍认为A节点应该分配资源，此时可能是因为集群B节点Slot数量配置不是最佳导致（Worker节点Slot配置少了）。

## SLOT_RATIO

Slot比例策略是根据Slot的使用率来进行调度，使用率越低的Slot优先级越高。

**计算逻辑**：
1. 获取Worker总Slot数
2. 获取未分配Slot数。
3. 使用率 = (总插槽数 - 未分配插槽数) / 总插槽数。

