/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.api;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;

public interface DataSourceChannel {
    public static final List<String> DEFAULT_DATABASES = ImmutableList.of("default");

    public OptionRule getDataSourceOptions(@NonNull String var1);

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String var1);

    public List<String> getTables(@NonNull String var1, Map<String, String> var2, String var3, Map<String, String> var4);

    public List<String> getDatabases(@NonNull String var1, @NonNull Map<String, String> var2);

    public boolean checkDataSourceConnectivity(@NonNull String var1, @NonNull Map<String, String> var2);

    default public boolean canAbleGetSchema() {
        return false;
    }

    public List<TableField> getTableFields(@NonNull String var1, @NonNull Map<String, String> var2, @NonNull String var3, @NonNull String var4);

    default public Map<String, List<TableField>> getTableFields(@NonNull String pluginName, @NonNull Map<String, String> requestParams, @NonNull String database, @NonNull List<String> tables) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (requestParams == null) {
            throw new NullPointerException("requestParams is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tables == null) {
            throw new NullPointerException("tables is marked non-null but is null");
        }
        return tables.parallelStream().collect(Collectors.toMap(Function.identity(), table -> this.getTableFields(pluginName, requestParams, database, (String)table)));
    }

    default public Boolean checkMetadataFieldIsRight(Map<String, String> requestParams) {
        return true;
    }

    default public Pair<String, String> getTableSyncMaxValue(String pluginName, Map<String, String> requestParams, String databaseName, String tableName, String updateFieldType) {
        return null;
    }

    default public Connection getConnection(String pluginName, Map<String, String> requestParams) {
        return null;
    }
}

