/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component(value="swaggerParameterDescriptionReader")
@Order(value=-2147482648)
public class ApiParamParameterBuilder
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        Optional apiParam = context.resolvedMethodParameter().findAnnotation(ApiParam.class);
        context.parameterBuilder().allowableValues(this.allowableValues(context.resolvedMethodParameter().getParameterType(), (String)apiParam.transform(this.toAllowableValue()).or((Object)"")));
        if (apiParam.isPresent()) {
            context.parameterBuilder().name(Strings.emptyToNull((String)((ApiParam)apiParam.get()).name()));
            context.parameterBuilder().description(Strings.emptyToNull((String)((ApiParam)apiParam.get()).value()));
            context.parameterBuilder().parameterAccess(Strings.emptyToNull((String)((ApiParam)apiParam.get()).access()));
            context.parameterBuilder().defaultValue(Strings.emptyToNull((String)((ApiParam)apiParam.get()).defaultValue()));
            context.parameterBuilder().allowMultiple(((ApiParam)apiParam.get()).allowMultiple());
            context.parameterBuilder().required(((ApiParam)apiParam.get()).required());
        }
    }

    private Function<ApiParam, String> toAllowableValue() {
        return new Function<ApiParam, String>(){

            public String apply(ApiParam input) {
                return input.allowableValues();
            }
        };
    }

    private AllowableValues allowableValues(ResolvedType parameterType, String allowableValueString) {
        AllowableValues allowableValues = null;
        if (!Strings.isNullOrEmpty((String)allowableValueString)) {
            allowableValues = ApiModelProperties.allowableValueFromString(allowableValueString);
        } else {
            if (parameterType.getErasedType().isEnum()) {
                allowableValues = Enums.allowableValues((Class)parameterType.getErasedType());
            }
            if (Collections.isContainerType((ResolvedType)parameterType)) {
                allowableValues = Enums.allowableValues((Class)Collections.collectionElementType((ResolvedType)parameterType).getErasedType());
            }
        }
        return allowableValues;
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

