/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.seatunnel.app.dal.dao.IJobInstanceDao;
import org.apache.seatunnel.app.dal.entity.JobInstance;
import org.apache.seatunnel.app.dal.mapper.JobInstanceMapper;
import org.apache.seatunnel.app.domain.dto.job.SeaTunnelJobInstanceDto;
import org.springframework.stereotype.Repository;

@Repository
public class JobInstanceDaoImpl
implements IJobInstanceDao {
    @Resource
    private JobInstanceMapper jobInstanceMapper;

    @Override
    public JobInstance getJobInstance(@NonNull Long jobInstanceId) {
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        return (JobInstance)this.jobInstanceMapper.selectById(jobInstanceId);
    }

    @Override
    public JobInstance getJobInstanceByEngineId(@NonNull Long jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        return (JobInstance)this.jobInstanceMapper.selectOne((Wrapper)new LambdaQueryWrapper((Object)new JobInstance()).eq(JobInstance::getJobEngineId, (Object)jobEngineId));
    }

    @Override
    public void update(@NonNull JobInstance jobInstance) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        this.jobInstanceMapper.updateById(jobInstance);
    }

    @Override
    public void insert(@NonNull JobInstance jobInstance) {
        if (jobInstance == null) {
            throw new NullPointerException("jobInstance is marked non-null but is null");
        }
        this.jobInstanceMapper.insert(jobInstance);
    }

    @Override
    public JobInstanceMapper getJobInstanceMapper() {
        return this.jobInstanceMapper;
    }

    @Override
    public IPage<SeaTunnelJobInstanceDto> queryJobInstanceListPaging(IPage<JobInstance> page, Date startTime, Date endTime, Long jobDefineId, String jobMode) {
        IPage<SeaTunnelJobInstanceDto> jobInstanceIPage = this.jobInstanceMapper.queryJobInstanceListPaging(page, startTime, endTime, jobDefineId, jobMode);
        return jobInstanceIPage;
    }

    @Override
    public List<JobInstance> getAllJobInstance(@NonNull List<Long> jobInstanceIdList) {
        if (jobInstanceIdList == null) {
            throw new NullPointerException("jobInstanceIdList is marked non-null but is null");
        }
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        for (long jobInstanceId : jobInstanceIdList) {
            JobInstance jobInstance = (JobInstance)this.jobInstanceMapper.selectById(Long.valueOf(jobInstanceId));
            jobInstances.add(jobInstance);
        }
        return jobInstances;
    }
}

