/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.connector.AbstractUpdateMapP;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.jet.pipeline.test.impl.ItemsDistributedFillBufferFn;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.sql.impl.row.JetSqlRow;

@PrivateApi
public final class JetDataSerializerHook
implements DataSerializerHook {
    public static final int DAG = 0;
    public static final int VERTEX = 1;
    public static final int EDGE = 2;
    public static final int APPLY_FN_ENTRY_PROCESSOR = 3;
    public static final int APPLY_VALUE_ENTRY_PROCESSOR = 4;
    public static final int TEST_SOURCES_ITEMS_DISTRIBUTED_FILL_BUFFER_FN = 5;
    public static final int JET_SQL_ROW = 6;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.jet", -10001);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new DAG();
                }
                case 1: {
                    return new Vertex();
                }
                case 2: {
                    return new Edge();
                }
                case 3: {
                    return new UpdateMapP.ApplyFnEntryProcessor();
                }
                case 4: {
                    return new AbstractUpdateMapP.ApplyValuesEntryProcessor();
                }
                case 5: {
                    return new ItemsDistributedFillBufferFn();
                }
                case 6: {
                    return new JetSqlRow();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

