/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms;

import lombok.NonNull;
import org.apache.seatunnel.app.dynamicforms.AbstractFormOption;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonProperty;

public class FormInputOption
extends AbstractFormOption {
    @JsonProperty(value="type")
    private final AbstractFormOption.FormType formType = AbstractFormOption.FormType.INPUT;
    private final InputType inputType;

    public FormInputOption(@NonNull InputType inputType, @NonNull String label, @NonNull String field) {
        super(label, field);
        if (inputType == null) {
            throw new NullPointerException("inputType is marked non-null but is null");
        }
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.inputType = inputType;
    }

    public AbstractFormOption.FormType getFormType() {
        return this.formType;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public static enum InputType {
        TEXT("text"),
        PASSWORD("password"),
        TEXTAREA("textarea");

        private String inputType;

        private InputType(String inputType) {
            this.inputType = inputType;
        }

        public String getInputType() {
            return this.inputType;
        }
    }
}

