/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.python.wrapper.translation;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.python.wrapper.SerializationException;
import org.apache.sedona.python.wrapper.SerializationException$;
import org.apache.sedona.python.wrapper.translation.CircleSerializer;
import org.apache.sedona.python.wrapper.translation.GeometrySerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBReader;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00053Q\u0001B\u0003\u0001\u0013EAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\u0002)BQA\u0010\u0001\u0005\u0002}\u0012\u0001\u0004U=uQ>tw)Z8nKR\u0014\u0018pU3sS\u0006d\u0017N_3s\u0015\t1q!A\u0006ue\u0006t7\u000f\\1uS>t'B\u0001\u0005\n\u0003\u001d9(/\u00199qKJT!AC\u0006\u0002\rALH\u000f[8o\u0015\taQ\"\u0001\u0004tK\u0012|g.\u0019\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xmE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r#\u001d\tQ\u0002E\u0004\u0002\u001c?5\tAD\u0003\u0002\u001e=\u00051AH]8piz\u001a\u0001!C\u0001\u0016\u0013\t\tC#A\u0004qC\u000e\\\u0017mZ3\n\u0005\r\"#\u0001D*fe&\fG.\u001b>bE2,'BA\u0011\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\tQ!A\u0005tKJL\u0017\r\\5{KV\t1\u0006\u0005\u0003\u0014Y9B\u0014BA\u0017\u0015\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005!q-Z8n\u0015\t\u0019D'A\u0002kiNT!!N\b\u0002\u00191|7-\u0019;j_:$Xm\u00195\n\u0005]\u0002$\u0001C$f_6,GO]=\u0011\u0007MI4(\u0003\u0002;)\t)\u0011I\u001d:bsB\u00111\u0003P\u0005\u0003{Q\u0011AAQ=uK\u0006YA-Z:fe&\fG.\u001b>f+\u0005\u0001\u0005\u0003B\n-q9\u0002")
public class PythonGeometrySerializer
implements Serializable {
    public Function1<Geometry, byte[]> serialize() {
        return (Function1 & Serializable)x0$1 -> {
            byte[] byArray;
            Geometry geometry = x0$1;
            if (geometry instanceof Circle) {
                Circle circle = (Circle)geometry;
                byArray = new CircleSerializer(circle).serialize();
            } else if (geometry != null) {
                Geometry geometry2 = geometry;
                byArray = new GeometrySerializer(geometry2).serialize();
            } else {
                throw new MatchError((Object)geometry);
            }
            return byArray;
        };
    }

    public Function1<byte[], Geometry> deserialize() {
        return (Function1 & Serializable)values -> {
            Geometry geometry;
            WKBReader reader = new WKBReader();
            byte isCircle = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(values)));
            int valuesLength = ((byte[])values).length;
            if (isCircle == 1) {
                Geometry geom = reader.read((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), 9, valuesLength));
                double radius = ByteBuffer.wrap((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), 1, 9)).getDouble();
                geometry = new Circle(geom, Predef$.MODULE$.double2Double(radius));
            } else if (isCircle == 0) {
                geometry = reader.read((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(values), 1, valuesLength));
            } else {
                throw new SerializationException("Can not deserialize object", SerializationException$.MODULE$.apply$default$2());
            }
            return geometry;
        };
    }
}

