/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.util.Assert;

public class DirectedEdgeStar
extends EdgeEndStar {
    private List resultAreaEdgeList;
    private Label label;
    private static final int SCANNING_FOR_INCOMING = 1;
    private static final int LINKING_TO_OUTGOING = 2;

    @Override
    public void insert(EdgeEnd ee) {
        DirectedEdge de = (DirectedEdge)ee;
        this.insertEdgeEnd(de, de);
    }

    public Label getLabel() {
        return this.label;
    }

    public int getOutgoingDegree() {
        int degree = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (!de.isInResult()) continue;
            ++degree;
        }
        return degree;
    }

    public int getOutgoingDegree(EdgeRing er) {
        int degree = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (de.getEdgeRing() != er) continue;
            ++degree;
        }
        return degree;
    }

    public DirectedEdge getRightmostEdge() {
        List edges = this.getEdges();
        int size = edges.size();
        if (size < 1) {
            return null;
        }
        DirectedEdge de0 = (DirectedEdge)edges.get(0);
        if (size == 1) {
            return de0;
        }
        DirectedEdge deLast = (DirectedEdge)edges.get(size - 1);
        int quad0 = de0.getQuadrant();
        int quad1 = deLast.getQuadrant();
        if (Quadrant.isNorthern(quad0) && Quadrant.isNorthern(quad1)) {
            return de0;
        }
        if (!Quadrant.isNorthern(quad0) && !Quadrant.isNorthern(quad1)) {
            return deLast;
        }
        Object nonHorizontalEdge = null;
        if (de0.getDy() != 0.0) {
            return de0;
        }
        if (deLast.getDy() != 0.0) {
            return deLast;
        }
        Assert.shouldNeverReachHere("found two horizontal edges incident on node");
        return null;
    }

    @Override
    public void computeLabelling(GeometryGraph[] geom) {
        super.computeLabelling(geom);
        this.label = new Label(-1);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            EdgeEnd ee = (EdgeEnd)it.next();
            Edge e = ee.getEdge();
            Label eLabel = e.getLabel();
            for (int i = 0; i < 2; ++i) {
                int eLoc = eLabel.getLocation(i);
                if (eLoc != 0 && eLoc != 1) continue;
                this.label.setLocation(i, 0);
            }
        }
    }

    public void mergeSymLabels() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.merge(de.getSym().getLabel());
        }
    }

    public void updateLabelling(Label nodeLabel) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            Label label = de.getLabel();
            label.setAllLocationsIfNull(0, nodeLabel.getLocation(0));
            label.setAllLocationsIfNull(1, nodeLabel.getLocation(1));
        }
    }

    private List getResultAreaEdges() {
        if (this.resultAreaEdgeList != null) {
            return this.resultAreaEdgeList;
        }
        this.resultAreaEdgeList = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (!de.isInResult() && !de.getSym().isInResult()) continue;
            this.resultAreaEdgeList.add(de);
        }
        return this.resultAreaEdgeList;
    }

    public void linkResultDirectedEdges() {
        this.getResultAreaEdges();
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        block4: for (int i = 0; i < this.resultAreaEdgeList.size(); ++i) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (!nextOut.getLabel().isArea()) continue;
            if (firstOut == null && nextOut.isInResult()) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (!nextIn.isInResult()) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (!nextOut.isInResult()) continue block4;
                    incoming.setNext(nextOut);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            if (firstOut == null) {
                throw new TopologyException("no outgoing dirEdge found", this.getCoordinate());
            }
            Assert.isTrue(firstOut.isInResult(), "unable to link last incoming dirEdge");
            incoming.setNext(firstOut);
        }
    }

    public void linkMinimalDirectedEdges(EdgeRing er) {
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state = 1;
        block4: for (int i = this.resultAreaEdgeList.size() - 1; i >= 0; --i) {
            DirectedEdge nextOut = (DirectedEdge)this.resultAreaEdgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstOut == null && nextOut.getEdgeRing() == er) {
                firstOut = nextOut;
            }
            switch (state) {
                case 1: {
                    if (nextIn.getEdgeRing() != er) continue block4;
                    incoming = nextIn;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (nextOut.getEdgeRing() != er) continue block4;
                    incoming.setNextMin(nextOut);
                    state = 1;
                }
            }
        }
        if (state == 2) {
            Assert.isTrue(firstOut != null, "found null for first outgoing dirEdge");
            Assert.isTrue(firstOut.getEdgeRing() == er, "unable to link last incoming dirEdge");
            incoming.setNextMin(firstOut);
        }
    }

    public void linkAllDirectedEdges() {
        this.getEdges();
        DirectedEdge prevOut = null;
        DirectedEdge firstIn = null;
        for (int i = this.edgeList.size() - 1; i >= 0; --i) {
            DirectedEdge nextOut = (DirectedEdge)this.edgeList.get(i);
            DirectedEdge nextIn = nextOut.getSym();
            if (firstIn == null) {
                firstIn = nextIn;
            }
            if (prevOut != null) {
                nextIn.setNext(prevOut);
            }
            prevOut = nextOut;
        }
        firstIn.setNext(prevOut);
    }

    public void findCoveredLineEdges() {
        int startLoc = -1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) continue;
            if (nextOut.isInResult()) {
                startLoc = 0;
                break;
            }
            if (!nextIn.isInResult()) continue;
            startLoc = 2;
            break;
        }
        if (startLoc == -1) {
            return;
        }
        int currLoc = startLoc;
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            DirectedEdge nextOut = (DirectedEdge)it2.next();
            DirectedEdge nextIn = nextOut.getSym();
            if (nextOut.isLineEdge()) {
                nextOut.getEdge().setCovered(currLoc == 0);
                continue;
            }
            if (nextOut.isInResult()) {
                currLoc = 2;
            }
            if (!nextIn.isInResult()) continue;
            currLoc = 0;
        }
    }

    public void computeDepths(DirectedEdge de) {
        int edgeIndex = this.findIndex(de);
        int startDepth = de.getDepth(1);
        int targetLastDepth = de.getDepth(2);
        int nextDepth = this.computeDepths(edgeIndex + 1, this.edgeList.size(), startDepth);
        int lastDepth = this.computeDepths(0, edgeIndex, nextDepth);
        if (lastDepth != targetLastDepth) {
            throw new TopologyException("depth mismatch at " + de.getCoordinate());
        }
    }

    private int computeDepths(int startIndex, int endIndex, int startDepth) {
        int currDepth = startDepth;
        for (int i = startIndex; i < endIndex; ++i) {
            DirectedEdge nextDe = (DirectedEdge)this.edgeList.get(i);
            nextDe.setEdgeDepths(2, currDepth);
            currDepth = nextDe.getDepth(1);
        }
        return currDepth;
    }

    @Override
    public void print(PrintStream out) {
        System.out.println("DirectedEdgeStar: " + this.getCoordinate());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            out.print("out ");
            de.print(out);
            out.println();
            out.print("in ");
            de.getSym().print(out);
            out.println();
        }
    }
}

