/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import java.awt.RenderingHints;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import javax.media.jai.RasterFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.sedona_sql.io.ImageWriteOptions;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0004\b\u00057!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u000b\u001d\u0003A\u0011\u0001%\t\u000f9\u0003!\u0019!C\u0005\u001f\"1!\f\u0001Q\u0001\nACqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004d\u0001\u0001\u0006I!\u0018\u0005\u0006I\u0002!\t%\u001a\u0005\u0006e\u0002!\te\u001d\u0005\u0006i\u0002!\t!\u001e\u0002\u0012\u000f\u0016|G/\u001b4g\r&dWm\u0016:ji\u0016\u0014(BA\b\u0011\u0003\tIwN\u0003\u0002\u0012%\u0005Q1/\u001a3p]\u0006|6/\u001d7\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005\u0005\u0012\u0012!C3yK\u000e,H/[8o\u0013\t\u0019cD\u0001\u0007PkR\u0004X\u000f^,sSR,'/\u0001\u0005tCZ,\u0007+\u0019;i!\t1sF\u0004\u0002([A\u0011\u0001fK\u0007\u0002S)\u0011!FG\u0001\u0007yI|w\u000e\u001e \u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-\n\u0011#[7bO\u0016<&/\u001b;f\u001fB$\u0018n\u001c8t!\t!T'D\u0001\u000f\u0013\t1dBA\tJ[\u0006<Wm\u0016:ji\u0016|\u0005\u000f^5p]N\f!\u0002Z1uCN\u001b\u0007.Z7b!\tID(D\u0001;\u0015\tY$#A\u0003usB,7/\u0003\u0002>u\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u000f\r|g\u000e^3yiB\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001\u0012\f\u0002\r!\fGm\\8q\u0013\t1\u0015I\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0003J\u0015.cU\n\u0005\u00025\u0001!)A%\u0002a\u0001K!)!'\u0002a\u0001g!)q'\u0002a\u0001q!)a(\u0002a\u0001\u007f\u0005!B)\u0012$B+2#vl\u0016*J)\u0016{\u0006+\u0011*B\u001bN+\u0012\u0001\u0015\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000bqaZ3pi&4gM\u0003\u0002V-\u0006\u0019qmY3\u000b\u0005]C\u0012\u0001C4f_R|w\u000e\\:\n\u0005e\u0013&AE$f_RKgMZ,sSR,\u0007+\u0019:b[N\fQ\u0003R#G\u0003VcEkX,S\u0013R+u\fU!S\u00036\u001b\u0006%A\u0002iMN,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\u000e\u000b!AZ:\n\u0005\t|&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006!\u0001NZ:!\u0003\u00159(/\u001b;f)\t1'\u000e\u0005\u0002hQ6\t1&\u0003\u0002jW\t!QK\\5u\u0011\u0015Y'\u00021\u0001m\u0003\r\u0011xn\u001e\t\u0003[Bl\u0011A\u001c\u0006\u0003_J\t\u0001bY1uC2L8\u000f^\u0005\u0003c:\u00141\"\u00138uKJt\u0017\r\u001c*po\u0006)1\r\\8tKR\ta-\u0001\u0003qCRDG#A\u0013")
public class GeotiffFileWriter
extends OutputWriter {
    private final String savePath;
    private final ImageWriteOptions imageWriteOptions;
    private final StructType dataSchema;
    private final GeoTiffWriteParams DEFAULT_WRITE_PARAMS;
    private final FileSystem hfs;

    private GeoTiffWriteParams DEFAULT_WRITE_PARAMS() {
        return this.DEFAULT_WRITE_PARAMS;
    }

    private FileSystem hfs() {
        return this.hfs;
    }

    public void write(InternalRow row) {
        InternalRow rowFields = row;
        StructType schemaFields = this.dataSchema;
        String[] fields = this.dataSchema.fieldNames();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).contains((Object)this.imageWriteOptions.colImage())) {
            schemaFields = (StructType)this.dataSchema.fields()[this.dataSchema.fieldIndex(this.imageWriteOptions.colImage())].dataType();
            rowFields = row.getStruct(this.dataSchema.fieldIndex(this.imageWriteOptions.colImage()), 6);
        }
        String tiffOrigin = rowFields.getString(schemaFields.fieldIndex(this.imageWriteOptions.colOrigin()));
        int tiffBands = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colBands()));
        int tiffWidth = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colWidth()));
        int tiffHeight = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colHeight()));
        Object tiffGeometry = Row$.MODULE$.fromSeq(rowFields.toSeq(schemaFields)).get(schemaFields.fieldIndex(this.imageWriteOptions.colGeometry()));
        double[] tiffData = rowFields.getArray(schemaFields.fieldIndex(this.imageWriteOptions.colData())).toDoubleArray();
        if (tiffBands == -1) {
            return;
        }
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)tiffWidth, (int)tiffHeight, (int)tiffBands, null);
        double[] pixelVal = (double[])Array$.MODULE$.ofDim(tiffBands, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffHeight).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffBands).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
                pixelVal$1[k] = tiffData[tiffHeight * tiffWidth * k + i * tiffWidth + j];
            });
            raster.setPixel(j, i, pixelVal);
        }));
        CoordinateReferenceSystem crs = CRS.decode((String)this.imageWriteOptions.writeToCRS(), (boolean)true);
        Coordinate[] coordinateList = null;
        if (tiffGeometry instanceof UTF8String) {
            WKTReader wktReader = new WKTReader();
            Polygon envGeom = (Polygon)wktReader.read(tiffGeometry.toString());
            coordinateList = envGeom.getCoordinates();
        } else {
            Geometry envGeom = GeometrySerializer$.MODULE$.deserialize((ArrayData)tiffGeometry);
            coordinateList = envGeom.getCoordinates();
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(coordinateList[0].x, coordinateList[2].x, coordinateList[0].y, coordinateList[2].y, crs);
        String writePath = ((Object)Paths.get(this.savePath, new Path(tiffOrigin).getName())).toString();
        FSDataOutputStream out = this.hfs().create(new Path(writePath));
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)out);
        Hints hints = null;
        if (format instanceof GeoTiffFormat) {
            hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(hints);
        GridCoverage2D gc = factory.create((CharSequence)"GRID", raster, (Envelope)referencedEnvelope);
        GeoTiffWriter writer = new GeoTiffWriter((Object)out, hints);
        ParameterValueGroup gtiffParams = new GeoTiffFormat().getWriteParameters();
        gtiffParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)this.DEFAULT_WRITE_PARAMS());
        GeneralParameterValue[] wps = (GeneralParameterValue[])gtiffParams.values().toArray((Object[])new GeneralParameterValue[1]);
        try {
            writer.write((GridCoverage)gc, wps);
            writer.dispose();
            out.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IOException;
            if (bl) {
                throwable2.printStackTrace();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void close() {
        this.hfs().close();
    }

    public String path() {
        return this.savePath;
    }

    public GeotiffFileWriter(String savePath, ImageWriteOptions imageWriteOptions, StructType dataSchema, TaskAttemptContext context) {
        this.savePath = savePath;
        this.imageWriteOptions = imageWriteOptions;
        this.dataSchema = dataSchema;
        this.DEFAULT_WRITE_PARAMS = new GeoTiffWriteParams();
        this.DEFAULT_WRITE_PARAMS().setCompressionMode(2);
        this.DEFAULT_WRITE_PARAMS().setCompressionType("LZW");
        this.DEFAULT_WRITE_PARAMS().setCompressionQuality(0.75f);
        this.DEFAULT_WRITE_PARAMS().setTilingMode(2);
        this.DEFAULT_WRITE_PARAMS().setTiling(512, 512);
        this.hfs = new Path(savePath).getFileSystem(context.getConfiguration());
    }
}

