/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.showcase;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GridType;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.spatialOperator.JoinQuery;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.sedona.core.spatialRDD.PolygonRDD;
import org.apache.sedona.core.spatialRDD.RectangleRDD;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.viz.core.ImageGenerator;
import org.apache.sedona.viz.core.ImageSerializableWrapper;
import org.apache.sedona.viz.core.ImageStitcher;
import org.apache.sedona.viz.core.RasterOverlayOperator;
import org.apache.sedona.viz.extension.imageGenerator.SedonaVizImageGenerator;
import org.apache.sedona.viz.extension.visualizationEffect.ChoroplethMap;
import org.apache.sedona.viz.extension.visualizationEffect.HeatMap;
import org.apache.sedona.viz.extension.visualizationEffect.ScatterPlot;
import org.apache.sedona.viz.utils.ColorizeOption;
import org.apache.sedona.viz.utils.ImageType;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public class Example {
    static JavaSparkContext sparkContext;
    static Properties prop;
    static String PointInputLocation;
    static Integer PointOffset;
    static FileDataSplitter PointSplitter;
    static Integer PointNumPartitions;
    static String RectangleInputLocation;
    static Integer RectangleOffset;
    static FileDataSplitter RectangleSplitter;
    static Integer RectangleNumPartitions;
    static String PolygonInputLocation;
    static Integer PolygonOffset;
    static FileDataSplitter PolygonSplitter;
    static Integer PolygonNumPartitions;
    static String LineStringInputLocation;
    static Integer LineStringOffset;
    static FileDataSplitter LineStringSplitter;
    static Integer LineStringNumPartitions;
    static Envelope USMainLandBoundary;
    static String earthdataInputLocation;
    static Integer earthdataNumPartitions;
    static int HDFIncrement;
    static int HDFOffset;
    static String HDFRootGroupName;
    static String HDFDataVariableName;
    static String[] HDFDataVariableList;
    static boolean HDFswitchXY;
    static String urlPrefix;

    public static boolean buildScatterPlot(String outputPath) {
        try {
            PolygonRDD spatialRDD = new PolygonRDD(sparkContext, PolygonInputLocation, PolygonSplitter, false, PolygonNumPartitions, StorageLevel.MEMORY_ONLY());
            ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, USMainLandBoundary, false);
            visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            SedonaVizImageGenerator imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
            visualizationOperator = new ScatterPlot(1000, 600, USMainLandBoundary, false, -1, -1, false, true);
            visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveVectorImageAsLocalFile(visualizationOperator.vectorImage, outputPath, ImageType.SVG);
            visualizationOperator = new ScatterPlot(1000, 600, USMainLandBoundary, false, -1, -1, true, true);
            visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.GREEN, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveVectorImageAsLocalFile((JavaPairRDD<Integer, String>)visualizationOperator.distributedVectorImage, "file://" + outputPath + "-distributed", ImageType.SVG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean buildHeatMap(String outputPath) {
        try {
            RectangleRDD spatialRDD = new RectangleRDD(sparkContext, RectangleInputLocation, RectangleSplitter, false, RectangleNumPartitions, StorageLevel.MEMORY_ONLY());
            HeatMap visualizationOperator = new HeatMap(1000, 600, USMainLandBoundary, false, 2);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            SedonaVizImageGenerator imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean buildChoroplethMap(String outputPath) {
        try {
            PointRDD spatialRDD = new PointRDD(sparkContext, PointInputLocation, PointOffset, PointSplitter, false, PointNumPartitions, StorageLevel.MEMORY_ONLY());
            PolygonRDD queryRDD = new PolygonRDD(sparkContext, PolygonInputLocation, PolygonSplitter, false, PolygonNumPartitions, StorageLevel.MEMORY_ONLY());
            spatialRDD.spatialPartitioning(GridType.KDBTREE);
            queryRDD.spatialPartitioning(spatialRDD.getPartitioner());
            spatialRDD.buildIndex(IndexType.RTREE, true);
            JavaPairRDD joinResult = JoinQuery.SpatialJoinQueryCountByKey((SpatialRDD)spatialRDD, (SpatialRDD)queryRDD, (boolean)true, (boolean)false);
            ChoroplethMap visualizationOperator = new ChoroplethMap(1000, 600, USMainLandBoundary, false);
            visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.RED, true);
            visualizationOperator.Visualize(sparkContext, (JavaPairRDD<Polygon, Long>)joinResult);
            ScatterPlot frontImage = new ScatterPlot(1000, 600, USMainLandBoundary, false);
            frontImage.CustomizeColor(0, 0, 0, 255, Color.GREEN, true);
            frontImage.Visualize(sparkContext, (SpatialRDD)queryRDD);
            RasterOverlayOperator overlayOperator = new RasterOverlayOperator(visualizationOperator.rasterImage);
            overlayOperator.JoinImage(frontImage.rasterImage);
            SedonaVizImageGenerator imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile(overlayOperator.backRasterImage, outputPath, ImageType.PNG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean parallelFilterRenderNoStitch(String outputPath) {
        try {
            RectangleRDD spatialRDD = new RectangleRDD(sparkContext, RectangleInputLocation, RectangleSplitter, false, RectangleNumPartitions, StorageLevel.MEMORY_ONLY());
            HeatMap visualizationOperator = new HeatMap(1000, 600, USMainLandBoundary, false, 2, 4, 4, true, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            SedonaVizImageGenerator imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile((JavaPairRDD<Integer, ImageSerializableWrapper>)visualizationOperator.distributedRasterImage, outputPath, ImageType.PNG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean parallelFilterRenderStitch(String outputPath) {
        try {
            RectangleRDD spatialRDD = new RectangleRDD(sparkContext, RectangleInputLocation, RectangleSplitter, false, RectangleNumPartitions, StorageLevel.MEMORY_ONLY());
            HeatMap visualizationOperator = new HeatMap(1000, 600, USMainLandBoundary, false, 2, 4, 4, true, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            ImageGenerator imageGenerator = new ImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile((JavaPairRDD<Integer, ImageSerializableWrapper>)visualizationOperator.distributedRasterImage, outputPath, ImageType.PNG, 0, 4, 4);
            ImageStitcher.stitchImagePartitionsFromLocalFile(outputPath, 1000, 600, 0, 4, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean earthdataVisualization(String outputPath) {
        try {
            EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(HDFIncrement, HDFOffset, HDFRootGroupName, HDFDataVariableList, HDFDataVariableName, HDFswitchXY, urlPrefix);
            PointRDD spatialRDD = new PointRDD(sparkContext, earthdataInputLocation, earthdataNumPartitions, (FlatMapFunction)earthdataHDFPoint, StorageLevel.MEMORY_ONLY());
            ScatterPlot visualizationOperator = new ScatterPlot(1000, 600, spatialRDD.boundaryEnvelope, ColorizeOption.EARTHOBSERVATION, false, false);
            visualizationOperator.CustomizeColor(255, 255, 255, 255, Color.BLUE, true);
            visualizationOperator.Visualize(sparkContext, (SpatialRDD)spatialRDD);
            SedonaVizImageGenerator imageGenerator = new SedonaVizImageGenerator();
            imageGenerator.SaveRasterImageAsLocalFile(visualizationOperator.rasterImage, outputPath, ImageType.PNG);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws IOException {
        SparkConf sparkConf = new SparkConf().setAppName("SedonaVizDemo").setMaster("local[4]");
        sparkContext = new JavaSparkContext(sparkConf);
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        prop = new Properties();
        String resourcePath = "src/test/resources/";
        String demoOutputPath = "target/demo";
        FileInputStream ConfFile = new FileInputStream(resourcePath + "babylon.point.properties");
        prop.load(ConfFile);
        String scatterPlotOutputPath = System.getProperty("user.dir") + "/" + demoOutputPath + "/scatterplot";
        String heatMapOutputPath = System.getProperty("user.dir") + "/" + demoOutputPath + "/heatmap";
        String choroplethMapOutputPath = System.getProperty("user.dir") + "/" + demoOutputPath + "/choroplethmap";
        String parallelFilterRenderStitchOutputPath = System.getProperty("user.dir") + "/" + demoOutputPath + "/parallelfilterrenderstitchheatmap";
        String earthdataScatterPlotOutputPath = System.getProperty("user.dir") + "/" + demoOutputPath + "/earthdatascatterplot";
        PointInputLocation = "file://" + System.getProperty("user.dir") + "/" + resourcePath + prop.getProperty("inputLocation");
        PointOffset = Integer.parseInt(prop.getProperty("offset"));
        PointSplitter = FileDataSplitter.getFileDataSplitter((String)prop.getProperty("splitter"));
        PointNumPartitions = Integer.parseInt(prop.getProperty("numPartitions"));
        ConfFile = new FileInputStream(resourcePath + "babylon.rectangle.properties");
        prop.load(ConfFile);
        RectangleInputLocation = "file://" + System.getProperty("user.dir") + "/" + resourcePath + prop.getProperty("inputLocation");
        RectangleOffset = Integer.parseInt(prop.getProperty("offset"));
        RectangleSplitter = FileDataSplitter.getFileDataSplitter((String)prop.getProperty("splitter"));
        RectangleNumPartitions = Integer.parseInt(prop.getProperty("numPartitions"));
        ConfFile = new FileInputStream(resourcePath + "babylon.polygon.properties");
        prop.load(ConfFile);
        PolygonInputLocation = "file://" + System.getProperty("user.dir") + "/" + resourcePath + prop.getProperty("inputLocation");
        PolygonOffset = Integer.parseInt(prop.getProperty("offset"));
        PolygonSplitter = FileDataSplitter.getFileDataSplitter((String)prop.getProperty("splitter"));
        PolygonNumPartitions = Integer.parseInt(prop.getProperty("numPartitions"));
        ConfFile = new FileInputStream(resourcePath + "babylon.linestring.properties");
        prop.load(ConfFile);
        LineStringInputLocation = "file://" + System.getProperty("user.dir") + "/" + resourcePath + prop.getProperty("inputLocation");
        LineStringOffset = Integer.parseInt(prop.getProperty("offset"));
        LineStringSplitter = FileDataSplitter.getFileDataSplitter((String)prop.getProperty("splitter"));
        LineStringNumPartitions = Integer.parseInt(prop.getProperty("numPartitions"));
        USMainLandBoundary = new Envelope(-126.79018, -64.630926, 24.863836, 50.0);
        earthdataInputLocation = System.getProperty("user.dir") + "/src/test/resources/modis/modis.csv";
        earthdataNumPartitions = 5;
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        HDFswitchXY = true;
        urlPrefix = System.getProperty("user.dir") + "/src/test/resources/modis/";
        if (Example.buildScatterPlot(scatterPlotOutputPath) && Example.buildHeatMap(heatMapOutputPath) && Example.buildChoroplethMap(choroplethMapOutputPath) && Example.parallelFilterRenderStitch(parallelFilterRenderStitchOutputPath + "-stitched") && Example.parallelFilterRenderNoStitch(parallelFilterRenderStitchOutputPath) && Example.earthdataVisualization(earthdataScatterPlotOutputPath)) {
            System.out.println("All 5 Demos have passed.");
        } else {
            System.out.println("Demos failed.");
        }
        sparkContext.stop();
    }

    static {
        HDFIncrement = 5;
        HDFOffset = 2;
        HDFRootGroupName = "MOD_Swath_LST";
        HDFDataVariableName = "LST";
        HDFDataVariableList = new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"};
        HDFswitchXY = true;
        urlPrefix = "";
    }
}

