/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.CoveringBBox;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class GeoParquetMetaData$
implements scala.Serializable {
    public static GeoParquetMetaData$ MODULE$;
    private final String VERSION;
    private final String GEOPARQUET_VERSION_KEY;
    private final String GEOPARQUET_CRS_KEY;
    private final String GEOPARQUET_COVERING_KEY;

    static {
        new GeoParquetMetaData$();
    }

    public String VERSION() {
        return this.VERSION;
    }

    public String GEOPARQUET_VERSION_KEY() {
        return this.GEOPARQUET_VERSION_KEY;
    }

    public String GEOPARQUET_CRS_KEY() {
        return this.GEOPARQUET_CRS_KEY;
    }

    public String GEOPARQUET_COVERING_KEY() {
        return this.GEOPARQUET_COVERING_KEY;
    }

    public Option<GeoParquetMetaData> parseKeyValueMetaData(java.util.Map<String, String> keyValueMetaData) {
        return Option$.MODULE$.apply((Object)keyValueMetaData.get("geo")).map((Function1 & Serializable & scala.Serializable)geo -> {
            Map columns;
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            JsonAST.JValue geoObject = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(geo), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            GeoParquetMetaData metadata = (GeoParquetMetaData)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(geoObject).camelizeKeys()).extract((Formats)formats, ManifestFactory$.MODULE$.classType(GeoParquetMetaData.class));
            Map x$11 = columns = (Map)((TraversableLike)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(geoObject).$bslash("columns")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(JsonAST.JValue.class)})))).map(arg_0 -> GeoParquetMetaData$.$anonfun$parseKeyValueMetaData$2((Formats)formats, arg_0), Map$.MODULE$.canBuildFrom());
            Option<String> x$12 = metadata.copy$default$1();
            String x$13 = metadata.copy$default$2();
            return metadata.copy(x$12, x$13, (Map<String, GeometryFieldMetaData>)x$11);
        });
    }

    public String toJson(GeoParquetMetaData geoParquetMetadata) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue geoObject = Extraction$.MODULE$.decompose((Object)geoParquetMetadata, (Formats)formats);
        Map columnsMap = (Map)((TraversableLike)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(geoObject).$bslash("columns")).extract((Formats)formats, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(JsonAST.JValue.class)})))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            JsonAST.JValue columnObject = (JsonAST.JValue)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)package$.MODULE$.jvalue2monadic(columnObject).underscoreKeys());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        JsonAST.JValue serializedGeoObject = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(geoObject).underscoreKeys()).mapField((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                Tuple2 tuple23 = tuple22;
                Object object = tuple23._1();
                String string = "columns";
                tuple2 = !(object != null ? !object.equals(string) : string != null) ? package$.MODULE$.JField().apply("columns", (JsonAST.JValue)package$.MODULE$.JObject().apply(columnsMap.toList())) : tuple22;
            } else if (tuple22 != null) {
                Tuple2 tuple24;
                tuple2 = tuple24 = tuple22;
            } else {
                throw new MatchError((Object)tuple22);
            }
            return tuple2;
        });
        return org.json4s.jackson.package$.MODULE$.compactJson(serializedGeoObject);
    }

    public Covering createCoveringColumnMetadata(String coveringColumnName, StructType schema) {
        int coveringColumnIndex = schema.fieldIndex(coveringColumnName);
        DataType dataType = schema.apply(coveringColumnIndex).dataType();
        if (!(dataType instanceof StructType)) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Covering column ").append(coveringColumnName).append(" is not a struct type").toString());
        }
        StructType structType = (StructType)dataType;
        Covering covering = this.coveringColumnTypeToCovering(coveringColumnName, structType);
        return covering;
    }

    private Covering coveringColumnTypeToCovering(String coveringColumnName, StructType coveringColumnType) {
        Covering covering;
        GeoParquetMetaData$.validateField$1("xmin", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("ymin", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("xmax", coveringColumnType, coveringColumnName);
        GeoParquetMetaData$.validateField$1("ymax", coveringColumnType, coveringColumnName);
        Option option = coveringColumnType.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetMetaData$.$anonfun$coveringColumnTypeToCovering$1(x$1)));
        if (option instanceof Some) {
            GeoParquetMetaData$.validateField$1("zmin", coveringColumnType, coveringColumnName);
            GeoParquetMetaData$.validateField$1("zmax", coveringColumnType, coveringColumnName);
            covering = new Covering(new CoveringBBox((Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmin", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymin", (List)Nil$.MODULE$))), (Option<Seq<String>>)new Some((Object)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"zmin", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmax", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymax", (List)Nil$.MODULE$))), (Option<Seq<String>>)new Some((Object)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"zmax", (List)Nil$.MODULE$)))));
        } else if (None$.MODULE$.equals(option)) {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coveringColumnType.fieldNames())).contains((Object)"zmax")) {
                throw new IllegalArgumentException(new StringBuilder(71).append("zmax should not present in covering column `").append(coveringColumnName).append("` since zmin is not present").toString());
            }
            covering = new Covering(new CoveringBBox((Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmin", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymin", (List)Nil$.MODULE$))), (Option<Seq<String>>)None$.MODULE$, (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"xmax", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)coveringColumnName, (List)new .colon.colon((Object)"ymax", (List)Nil$.MODULE$))), (Option<Seq<String>>)None$.MODULE$));
        } else {
            throw new MatchError((Object)option);
        }
        return covering;
    }

    public GeoParquetMetaData apply(Option<String> version, String primaryColumn, Map<String, GeometryFieldMetaData> columns) {
        return new GeoParquetMetaData(version, primaryColumn, columns);
    }

    public Option<Tuple3<Option<String>, String, Map<String, GeometryFieldMetaData>>> unapply(GeoParquetMetaData x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.version(), (Object)x$0.primaryColumn(), x$0.columns()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$parseKeyValueMetaData$2(Formats formats$1, Tuple2 x0$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            String name = (String)tuple22._1();
            JsonAST.JValue columnObject = (JsonAST.JValue)tuple22._2();
            GeometryFieldMetaData fieldMetadata = (GeometryFieldMetaData)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(columnObject).camelizeKeys()).extract(formats$1, ManifestFactory$.MODULE$.classType(GeometryFieldMetaData.class));
            JsonAST.JValue jValue = package$.MODULE$.jvalue2monadic(columnObject).$bslash("crs");
            JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
            JsonAST.JValue jValue2 = jValue;
            if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
                None$ x$1 = None$.MODULE$;
                String x$2 = fieldMetadata.copy$default$1();
                Seq<String> x$3 = fieldMetadata.copy$default$2();
                Seq<Object> x$4 = fieldMetadata.copy$default$3();
                Option<Covering> x$5 = fieldMetadata.copy$default$5();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata.copy(x$2, x$3, x$4, (Option<JsonAST.JValue>)x$1, x$5));
            } else {
                JsonAST.JNull$ jNull$ = package$.MODULE$.JNull();
                JsonAST.JValue jValue3 = jValue;
                if (!(jNull$ != null ? !jNull$.equals(jValue3) : jValue3 != null)) {
                    Some x$6 = new Some((Object)package$.MODULE$.JNull());
                    String x$7 = fieldMetadata.copy$default$1();
                    Seq<String> x$8 = fieldMetadata.copy$default$2();
                    Seq<Object> x$9 = fieldMetadata.copy$default$3();
                    Option<Covering> x$10 = fieldMetadata.copy$default$5();
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata.copy(x$7, x$8, x$9, (Option<JsonAST.JValue>)x$6, x$10));
                } else {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)fieldMetadata);
                }
            }
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple23 = tuple2;
        return tuple23;
    }

    private static final void validateField$1(String fieldName, StructType coveringColumnType$1, String coveringColumnName$1) {
        DataType fieldType;
        int index = coveringColumnType$1.fieldIndex(fieldName);
        DataType dataType = fieldType = coveringColumnType$1.apply(index).dataType();
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType == null ? floatType$ != null : !dataType.equals(floatType$)) {
            DataType dataType2 = fieldType;
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            if (dataType2 == null ? doubleType$ != null : !dataType2.equals(doubleType$)) {
                throw new IllegalArgumentException(new StringBuilder(52).append("`").append(fieldName).append("` in covering column `").append(coveringColumnName$1).append("` is not float or double type").toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$coveringColumnTypeToCovering$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "zmin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GeoParquetMetaData$() {
        MODULE$ = this;
        this.VERSION = "1.1.0";
        this.GEOPARQUET_VERSION_KEY = "geoparquet.version";
        this.GEOPARQUET_CRS_KEY = "geoparquet.crs";
        this.GEOPARQUET_COVERING_KEY = "geoparquet.covering";
    }
}

