/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUb\u0001\u0002\f\u0018\u0001\u0019B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001d\")a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00015\")1\f\u0001C!9\")Q\r\u0001C!M\")!\u000e\u0001C!W\")A\u000f\u0001C\u0001k\")q\u000f\u0001C!q\"9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003C\u0003A\u0011IAR\u0011\u001d\ty\u000b\u0001C!\u0003c;q!!/\u0018\u0011\u0003\tYL\u0002\u0004\u0017/!\u0005\u0011Q\u0018\u0005\u0007->!\t!a5\t\u000f\u0005Uw\u0002\"\u0001\u0002X\"9\u0011\u0011]\b\u0005\n\u0005\r\bb\u0002B\b\u001f\u0011%!\u0011\u0003\u0005\b\u00057yA\u0011\u0002B\u000f\u0011%\u0011)cDA\u0001\n\u0013\u00119C\u0001\u000bHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u00031e\tq\u0001]1scV,GO\u0003\u0002\u001b7\u0005YA-\u0019;bg>,(oY3t\u0015\taR$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M9\u0001aJ\u0016/ear\u0004C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003Q1J!!L\f\u00031\u001d+w\u000eU1scV,GOR5mK\u001a{'/\\1u\u0005\u0006\u001cX\r\u0005\u00020a5\t\u0011$\u0003\u000223\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Uj\u0012aB:pkJ\u001cWm]\u0005\u0003oQ\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\bP\u0007\u0002u)\u00111hH\u0001\tS:$XM\u001d8bY&\u0011QH\u000f\u0002\b\u0019><w-\u001b8h!\ty\u0014J\u0004\u0002A\r:\u0011\u0011\tR\u0007\u0002\u0005*\u00111)J\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015\u000bQa]2bY\u0006L!a\u0012%\u0002\u000fA\f7m[1hK*\tQ)\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011q\tS\u0001\u000egB\fG/[1m\r&dG/\u001a:\u0016\u00039\u00032a\u0014)S\u001b\u0005A\u0015BA)I\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001fU\u0005\u0003)^\u0011qcR3p!\u0006\u0014\u0018/^3u'B\fG/[1m\r&dG/\u001a:\u0002\u001dM\u0004\u0018\r^5bY\u001aKG\u000e^3sA\u00051A(\u001b8jiz\"\"\u0001W-\u0011\u0005!\u0002\u0001\"\u0002'\u0004\u0001\u0004qE#\u0001-\u0002\r\u0015\fX/\u00197t)\ti\u0006\r\u0005\u0002P=&\u0011q\f\u0013\u0002\b\u0005>|G.Z1o\u0011\u0015\tW\u00011\u0001c\u0003\u0015yG\u000f[3s!\ty5-\u0003\u0002e\u0011\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u001a\t\u0003\u001f\"L!!\u001b%\u0003\u0007%sG/\u0001\u0005u_N#(/\u001b8h)\u0005a\u0007CA7r\u001d\tqw\u000e\u0005\u0002B\u0011&\u0011\u0001\u000fS\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002q\u0011\u0006)r/\u001b;i'B\fG/[1m!J,G-[2bi\u0016\u001cHC\u0001-w\u0011\u0015a\u0005\u00021\u0001S\u0003-IgNZ3s'\u000eDW-\\1\u0015\u000fe\f\t!!\u0004\u0002\u0018A\u0019q\n\u0015>\u0011\u0005mtX\"\u0001?\u000b\u0005ul\u0012!\u0002;za\u0016\u001c\u0018BA@}\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t9!!\u0003\u000e\u0003uI1!a\u0003\u001e\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\ty!\u0003a\u0001\u0003#\t!\u0002]1sC6,G/\u001a:t!\u0015i\u00171\u00037m\u0013\r\t)b\u001d\u0002\u0004\u001b\u0006\u0004\bbBA\r\u0013\u0001\u0007\u00111D\u0001\u0006M&dWm\u001d\t\u0006\u007f\u0005u\u0011\u0011E\u0005\u0004\u0003?Y%aA*fcB!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012A\u00014t\u0015\r\tY#I\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005=\u0012Q\u0005\u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GCCA\u001b\u0003w\ti$!\u0014\u0002RA\u0019q&a\u000e\n\u0007\u0005e\u0012DA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0004\u0002\u0004)\u0001\r!!\u0002\t\u000f\u0005}\"\u00021\u0001\u0002B\u0005\u0019!n\u001c2\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bRA!a\u0012\u0002*\u0005IQ.\u00199sK\u0012,8-Z\u0005\u0005\u0003\u0017\n)EA\u0002K_\nDq!a\u0014\u000b\u0001\u0004\t\t\"A\u0004paRLwN\\:\t\r\u0005M#\u00021\u0001{\u0003)!\u0017\r^1TG\",W.Y\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!\u0017\u0002x\u0005e\u00141PA@\u0003\u0007\u000by)!%\u0011\u000f=\u000bY&a\u0018\u0002f%\u0019\u0011Q\f%\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0018\u0002b%\u0019\u00111M\r\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004RaPA4\u0003WJ1!!\u001bL\u0005!IE/\u001a:bi>\u0014\b\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005ET$\u0001\u0005dCR\fG._:u\u0013\u0011\t)(a\u001c\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003\u0007Y\u0001\u0019AA\u0003\u0011\u0019\t\u0019f\u0003a\u0001u\"1\u0011QP\u0006A\u0002i\fq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003\u0003[\u0001\u0019\u0001>\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011QQ\u0006A\u0002\u0005\u001d\u0015a\u00024jYR,'o\u001d\t\u0006\u007f\u0005u\u0011\u0011\u0012\t\u0004g\u0005-\u0015bAAGi\t1a)\u001b7uKJDq!a\u0014\f\u0001\u0004\t\t\u0002C\u0004\u0002\u0014.\u0001\r!!&\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*!\u000b\u0002\t\r|gNZ\u0005\u0005\u0003?\u000bIJA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019Q,!*\t\u000f\u0005\u001dF\u00021\u0001\u0002*\u0006AA-\u0019;b)f\u0004X\rE\u0002|\u0003WK1!!,}\u0005!!\u0015\r^1UsB,\u0017\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B/\u00024\u0006U\u0006bBA\u0002\u001b\u0001\u0007\u0011Q\u0001\u0005\u0007\u0003ok\u0001\u0019\u0001>\u0002\rM\u001c\u0007.Z7b\u0003Q9Um\u001c)beF,X\r\u001e$jY\u00164uN]7biB\u0011\u0001fD\n\u0007\u001f\u0005}\u0006(!2\u0011\u0007=\u000b\t-C\u0002\u0002D\"\u0013a!\u00118z%\u00164\u0007\u0003BAd\u0003#l!!!3\u000b\t\u0005-\u0017QZ\u0001\u0003S>T!!a4\u0002\t)\fg/Y\u0005\u0004\u0015\u0006%GCAA^\u0003YiWM]4f'\u000eDW-\\1t\u0013:\u0004\u0016M]1mY\u0016dGcB=\u0002Z\u0006m\u0017q\u001c\u0005\b\u0003\u001f\t\u0002\u0019AA\t\u0011\u001d\ti.\u0005a\u0001\u00037\tABZ5mKN$v\u000eV8vG\"Dq!a\u0001\u0012\u0001\u0004\t)!\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\nu\u0006\u0015\u0018Q\u001fB\u0002\u0005\u001bAq!a:\u0013\u0001\u0004\tI/\u0001\u0004g_>$XM\u001d\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*!\u00111FAx\u0015\tA\u0012%\u0003\u0003\u0002t\u00065(A\u0002$p_R,'\u000fC\u0004\u0002xJ\u0001\r!!?\u0002!-,\u0017PV1mk\u0016lU\r^1ECR\f\u0007CBA~\u0005\u0003aG.\u0004\u0002\u0002~*!\u0011q`Ag\u0003\u0011)H/\u001b7\n\t\u0005U\u0011Q \u0005\b\u0005\u000b\u0011\u0002\u0019\u0001B\u0004\u0003%\u0019wN\u001c<feR,'\u000fE\u0002)\u0005\u0013I1Aa\u0003\u0018\u0005\u0001:Um\u001c)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\t\u000f\u0005=!\u00031\u0001\u0002\u0012\u00059B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\bs\nM!q\u0003B\r\u0011\u0019\u0011)b\u0005a\u0001Y\u0006a1o\u00195f[\u0006\u001cFO]5oO\"9\u0011q_\nA\u0002\u0005e\bbBA\b'\u0001\u0007\u0011\u0011C\u0001%e\u0016\u0004H.Y2f\u000f\u0016|W.\u001a;ss\u000e{G.^7o/&$\bnR3p[\u0016$(/_+E)R9!Pa\b\u0003\"\t\r\u0002BBA\\)\u0001\u0007!\u0010C\u0004\u0002xR\u0001\r!!?\t\u000f\u0005=A\u00031\u0001\u0002\u0012\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0006\t\u0005\u0005W\u0011\t$\u0004\u0002\u0003.)!!qFAg\u0003\u0011a\u0017M\\4\n\t\tM\"Q\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return new StringBuilder(10).append("GeoParquet").append(this.spatialFilter().map((Function1 & Serializable)filter -> new StringBuilder(23).append(" with spatial filter [").append(filter.simpleString()).append("]").toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = sparkSession.sessionState().conf();
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sqlConf.writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sqlConf.parquetOutputTimestampType().toString());
        conf.set(SQLConf$.MODULE$.PARQUET_FIELD_ID_WRITE_ENABLED().key(), Boolean.toString(sqlConf.parquetFieldIdWriteEnabled()));
        conf.set(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), Boolean.toString(sqlConf.legacyParquetNanosAsLong()));
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option parquet.summary.metadata.level to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sparkSession.sessionState().conf().parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sparkSession.sessionState().conf().legacyParquetNanosAsLong());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean parquetFilterPushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        String datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
        String int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            ParquetRecordReader parquetRecordReader;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = file.toPath();
            FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true).getFileMetaData();
            Map map = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
            Map map2 = footerFileMetaData.getKeyValueMetaData();
            RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, parquetFilterPushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)x$2 -> parquetFilters.createFilter(x$2))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(this, metadata)));
            if (!shouldScanFile) {
                return package$.MODULE$.Seq().empty().iterator();
            }
            None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            if (enableVectorizedReader) {
                this.logWarning((Function0 & Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
            }
            this.logDebug((Function0 & Serializable)() -> "Falling back to parquet-mr");
            GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseSpec, int96RebaseSpec, options);
            if (pushed.isDefined() && enableRecordFilter) {
                FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
            } else {
                parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
            }
            ParquetRecordReader reader = parquetRecordReader;
            RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
            RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
            try {
                readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$7(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

