/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public abstract class AbstractAutoServiceRegistration<R extends Registration>
extends AbstractDiscoveryLifecycle
implements AutoServiceRegistration {
    private final ServiceRegistry<R> serviceRegistry;
    private AutoServiceRegistrationProperties properties;

    @Deprecated
    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry, AutoServiceRegistrationProperties properties) {
        this.serviceRegistry = serviceRegistry;
        this.properties = properties;
    }

    protected ServiceRegistry<R> getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected abstract R getRegistration();

    protected abstract R getManagementRegistration();

    @Override
    protected void register() {
        this.serviceRegistry.register(this.getRegistration());
    }

    @Override
    protected void registerManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.register(registration);
        }
    }

    @Override
    protected void deregister() {
        this.serviceRegistry.deregister(this.getRegistration());
    }

    @Override
    protected void deregisterManagement() {
        R registration = this.getManagementRegistration();
        if (registration != null) {
            this.serviceRegistry.deregister(registration);
        }
    }

    @Override
    public void stop() {
        if (this.getRunning().compareAndSet(true, false) && this.isEnabled()) {
            this.deregister();
            if (this.shouldRegisterManagement()) {
                this.deregisterManagement();
            }
            this.serviceRegistry.close();
        }
    }

    @Override
    protected boolean shouldRegisterManagement() {
        if (this.properties == null || this.properties.isRegisterManagement()) {
            return super.shouldRegisterManagement();
        }
        return false;
    }
}

