/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx;

import com.netflix.config.DynamicPropertyFactory;
import io.netty.buffer.ByteBuf;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import javax.xml.ws.Holder;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.SimpleJsonObject;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class VertxUtils {
    private static final Logger LOGGER;
    private static final long BLOCKED_THREAD_CHECK_INTERVAL = 0x3FFFFFFFFFFFFFFFL;
    private static Map<String, Vertx> vertxMap;

    private VertxUtils() {
    }

    public static Map<String, Vertx> getVertxMap() {
        return vertxMap;
    }

    public static <T extends AbstractVerticle> void deployVerticle(Vertx vertx, Class<T> cls, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        vertx.deployVerticle(cls.getName(), options);
    }

    public static <CLIENT_POOL> DeploymentOptions createClientDeployOptions(ClientPoolManager<CLIENT_POOL> clientMgr, int instanceCount) {
        DeploymentOptions options = new DeploymentOptions().setInstances(instanceCount);
        SimpleJsonObject config = new SimpleJsonObject();
        config.put("clientMgr", clientMgr);
        options.setConfig((JsonObject)config);
        return options;
    }

    public static <VERTICLE extends Verticle> boolean blockDeploy(Vertx vertx, Class<VERTICLE> cls, DeploymentOptions options) throws InterruptedException {
        Holder result = new Holder();
        CountDownLatch latch = new CountDownLatch(1);
        vertx.deployVerticle(cls.getName(), options, ar -> {
            result.value = ar.succeeded();
            if (ar.failed()) {
                LOGGER.error("deploy vertx failed, cause ", ar.cause());
            }
            latch.countDown();
        });
        latch.await();
        return (Boolean)result.value;
    }

    public static Vertx getOrCreateVertxByName(String name, VertxOptions vertxOptions) {
        return vertxMap.computeIfAbsent(name, vertxName -> VertxUtils.init(vertxName, vertxOptions));
    }

    public static Vertx init(VertxOptions vertxOptions) {
        return VertxUtils.init(null, vertxOptions);
    }

    public static Vertx init(String name, VertxOptions vertxOptions) {
        boolean isDebug;
        if (vertxOptions == null) {
            vertxOptions = new VertxOptions();
        }
        if (isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp")) {
            vertxOptions.setBlockedThreadCheckInterval(0x3FFFFFFFFFFFFFFFL);
            LOGGER.info("in debug mode, disable blocked thread check.");
        }
        VertxUtils.configureVertxFileCaching(vertxOptions);
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        VertxUtils.enhanceVertx(name, vertx);
        return vertx;
    }

    private static void enhanceVertx(String name, Vertx vertx) {
        if (StringUtils.isEmpty((Object)name)) {
            return;
        }
        Field field = ReflectionUtils.findField(VertxImpl.class, (String)"eventLoopThreadFactory");
        field.setAccessible(true);
        VertxThreadFactory eventLoopThreadFactory = (VertxThreadFactory)ReflectionUtils.getField((Field)field, (Object)vertx);
        field = ReflectionUtils.findField(eventLoopThreadFactory.getClass(), (String)"prefix");
        field.setAccessible(true);
        String prefix = (String)ReflectionUtils.getField((Field)field, (Object)eventLoopThreadFactory);
        ReflectionUtils.setField((Field)field, (Object)eventLoopThreadFactory, (Object)(name + "-" + prefix));
    }

    protected static void configureVertxFileCaching(VertxOptions vertxOptions) {
        boolean disableFileCPResolving = DynamicPropertyFactory.getInstance().getBooleanProperty("vertx.disableFileCPResolving", true).get();
        vertxOptions.getFileSystemOptions().setClassPathResolvingEnabled(!disableFileCPResolving);
    }

    public static byte[] getBytesFast(InputStream inputStream) throws IOException {
        if (BufferInputStream.class.isInstance(inputStream)) {
            return VertxUtils.getBytesFast(((BufferInputStream)((Object)inputStream)).getByteBuf());
        }
        return IOUtils.toByteArray((InputStream)inputStream);
    }

    public static byte[] getBytesFast(Buffer buffer) {
        ByteBuf byteBuf = buffer.getByteBuf();
        return VertxUtils.getBytesFast(byteBuf);
    }

    public static byte[] getBytesFast(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        byte[] arr = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, arr);
        return arr;
    }

    public static CompletableFuture<Void> closeVertxByName(String name) {
        LOGGER.info("Closing vertx {}.", (Object)name);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Vertx vertx = vertxMap.remove(name);
        if (vertx == null) {
            LOGGER.info("Vertx {} not exist.", (Object)name);
            future.complete(null);
            return future;
        }
        vertx.close(ar -> {
            if (ar.succeeded()) {
                LOGGER.info("Success to close vertx {}.", (Object)name);
                future.complete(null);
                return;
            }
            future.completeExceptionally(ar.cause());
        });
        return future;
    }

    public static void blockCloseVertxByName(String name) {
        CompletableFuture<Void> future = VertxUtils.closeVertxByName(name);
        try {
            future.get();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to wait close vertx {}.", (Object)name, (Object)e);
        }
    }

    public static void blockCloseVertx(Vertx vertx) {
        CountDownLatch latch = new CountDownLatch(1);
        vertx.close(ar -> {
            if (ar.succeeded()) {
                LOGGER.info("Success to close vertx {}.", (Object)vertx);
            } else {
                LOGGER.info("Failed to close vertx {}.", (Object)vertx);
            }
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOGGER.info("Failed to wait close vertx {}.", (Object)vertx);
        }
    }

    static {
        System.setProperty("vertx.logger-delegate-factory-class-name", SLF4JLogDelegateFactory.class.getName());
        io.vertx.core.logging.LoggerFactory.initialise();
        LOGGER = LoggerFactory.getLogger(VertxUtils.class);
        vertxMap = new ConcurrentHashMapEx();
    }
}

