/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.google.common.eventbus.EventBus;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SpectatorUtils;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.metrics.core.meter.vertx.HttpClientEndpointsMeter;
import org.apache.servicecomb.metrics.core.meter.vertx.ServerEndpointsMeter;

public class VertxMetersInitializer
implements MetricsInitializer {
    public static final String VERTX_ENDPOINTS = "servicecomb.vertx.endpoints";
    public static final String ENDPOINTS_TYPE = "type";
    public static final String ENDPOINTS_CLINET = "client";
    public static final String ENDPOINTS_SERVER = "server";

    public void init(GlobalRegistry globalRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        Registry registry = globalRegistry.getDefaultRegistry();
        Id endpointsId = registry.createId(VERTX_ENDPOINTS);
        HttpClientEndpointsMeter clientMeter = new HttpClientEndpointsMeter(endpointsId.withTag(ENDPOINTS_TYPE, ENDPOINTS_CLINET), AbstractTransport.getTransportVertxFactory().getMetricsFactory().getVertxMetrics().getClientEndpointMetricManager().getClientEndpointMetricMap());
        SpectatorUtils.registerMeter((Registry)registry, (Meter)clientMeter);
        ServerEndpointsMeter serverMeter = new ServerEndpointsMeter(endpointsId.withTag(ENDPOINTS_TYPE, ENDPOINTS_SERVER), AbstractTransport.getTransportVertxFactory().getMetricsFactory().getVertxMetrics().getServerEndpointMetricMap());
        SpectatorUtils.registerMeter((Registry)registry, (Meter)serverMeter);
    }
}

