/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import io.searchbox.client.JestClient;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.springframework.boot.actuate.autoconfigure.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.ElasticsearchHealthIndicator;
import org.springframework.boot.actuate.health.ElasticsearchHealthIndicatorProperties;
import org.springframework.boot.actuate.health.ElasticsearchJestHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

class ElasticsearchHealthIndicatorConfiguration {
    ElasticsearchHealthIndicatorConfiguration() {
    }

    @Configuration
    @ConditionalOnBean(value={JestClient.class})
    @ConditionalOnEnabledHealthIndicator(value="elasticsearch")
    static class ElasticsearchJestHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<ElasticsearchJestHealthIndicator, JestClient> {
        private final Map<String, JestClient> clients;

        ElasticsearchJestHealthIndicatorConfiguration(Map<String, JestClient> clients) {
            this.clients = clients;
        }

        @Bean
        @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
        public HealthIndicator elasticsearchHealthIndicator() {
            return this.createHealthIndicator(this.clients);
        }

        @Override
        protected ElasticsearchJestHealthIndicator createHealthIndicator(JestClient client) {
            return new ElasticsearchJestHealthIndicator(client);
        }
    }

    @Configuration
    @ConditionalOnBean(value={Client.class})
    @ConditionalOnEnabledHealthIndicator(value="elasticsearch")
    @EnableConfigurationProperties(value={ElasticsearchHealthIndicatorProperties.class})
    static class ElasticsearchClientHealthIndicatorConfiguration
    extends CompositeHealthIndicatorConfiguration<ElasticsearchHealthIndicator, Client> {
        private final Map<String, Client> clients;
        private final ElasticsearchHealthIndicatorProperties properties;

        ElasticsearchClientHealthIndicatorConfiguration(Map<String, Client> clients, ElasticsearchHealthIndicatorProperties properties) {
            this.clients = clients;
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator"})
        public HealthIndicator elasticsearchHealthIndicator() {
            return this.createHealthIndicator(this.clients);
        }

        @Override
        protected ElasticsearchHealthIndicator createHealthIndicator(Client client) {
            return new ElasticsearchHealthIndicator(client, this.properties);
        }
    }
}

