/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.flyway")
public class FlywayEndpoint
extends AbstractEndpoint<List<FlywayReport>> {
    private final Map<String, Flyway> flyways;

    public FlywayEndpoint(Flyway flyway) {
        this(Collections.singletonMap("default", flyway));
    }

    public FlywayEndpoint(Map<String, Flyway> flyways) {
        super("flyway");
        Assert.notEmpty(flyways, (String)"Flyways must be specified");
        this.flyways = flyways;
    }

    @Override
    public List<FlywayReport> invoke() {
        ArrayList<FlywayReport> reports = new ArrayList<FlywayReport>();
        for (Map.Entry<String, Flyway> entry : this.flyways.entrySet()) {
            ArrayList<FlywayMigration> migrations = new ArrayList<FlywayMigration>();
            for (MigrationInfo info : entry.getValue().info().all()) {
                migrations.add(new FlywayMigration(info));
            }
            reports.add(new FlywayReport(entry.getKey(), migrations));
        }
        return reports;
    }

    public static class FlywayMigration {
        private final MigrationType type;
        private final Integer checksum;
        private final String version;
        private final String description;
        private final String script;
        private final MigrationState state;
        private final Date installedOn;
        private final Integer executionTime;

        public FlywayMigration(MigrationInfo info) {
            this.type = info.getType();
            this.checksum = info.getChecksum();
            this.version = this.nullSafeToString(info.getVersion());
            this.description = info.getDescription();
            this.script = info.getScript();
            this.state = info.getState();
            this.installedOn = info.getInstalledOn();
            this.executionTime = info.getExecutionTime();
        }

        private String nullSafeToString(Object obj) {
            return obj != null ? obj.toString() : null;
        }

        public MigrationType getType() {
            return this.type;
        }

        public Integer getChecksum() {
            return this.checksum;
        }

        public String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public String getScript() {
            return this.script;
        }

        public MigrationState getState() {
            return this.state;
        }

        public Date getInstalledOn() {
            return this.installedOn;
        }

        public Integer getExecutionTime() {
            return this.executionTime;
        }
    }

    public static class FlywayReport {
        private final String name;
        private final List<FlywayMigration> migrations;

        public FlywayReport(String name, List<FlywayMigration> migrations) {
            this.name = name;
            this.migrations = migrations;
        }

        public String getName() {
            return this.name;
        }

        public List<FlywayMigration> getMigrations() {
            return this.migrations;
        }
    }
}

