/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MvcEndpointSecurityInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog(MvcEndpointSecurityInterceptor.class);
    private final boolean secure;
    private final List<String> roles;
    private AtomicBoolean loggedUnauthorizedAttempt = new AtomicBoolean();

    public MvcEndpointSecurityInterceptor(boolean secure, List<String> roles) {
        this.secure = secure;
        this.roles = roles;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (CorsUtils.isPreFlightRequest((HttpServletRequest)request) || !this.secure) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        if (HttpMethod.OPTIONS.matches(request.getMethod()) && !(handlerMethod.getBean() instanceof MvcEndpoint)) {
            return true;
        }
        MvcEndpoint mvcEndpoint = (MvcEndpoint)handlerMethod.getBean();
        if (!mvcEndpoint.isSensitive()) {
            return true;
        }
        if (this.isUserAllowedAccess(request)) {
            return true;
        }
        this.sendFailureResponse(request, response);
        return false;
    }

    private boolean isUserAllowedAccess(HttpServletRequest request) {
        AuthoritiesValidator authoritiesValidator = null;
        if (this.isSpringSecurityAvailable()) {
            authoritiesValidator = new AuthoritiesValidator();
        }
        for (String role : this.roles) {
            if (request.isUserInRole(role)) {
                return true;
            }
            if (authoritiesValidator == null || !authoritiesValidator.hasAuthority(role)) continue;
            return true;
        }
        return false;
    }

    private boolean isSpringSecurityAvailable() {
        return ClassUtils.isPresent((String)"org.springframework.security.config.annotation.web.WebSecurityConfigurer", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private void sendFailureResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getUserPrincipal() != null) {
            String roles = StringUtils.collectionToDelimitedString(this.roles, (String)" ");
            response.sendError(HttpStatus.FORBIDDEN.value(), "Access is denied. User must have one of the these roles: " + roles);
        } else {
            this.logUnauthorizedAttempt();
            response.sendError(HttpStatus.UNAUTHORIZED.value(), "Full authentication is required to access this resource.");
        }
    }

    private void logUnauthorizedAttempt() {
        if (this.loggedUnauthorizedAttempt.compareAndSet(false, true) && logger.isInfoEnabled()) {
            logger.info((Object)"Full authentication is required to access actuator endpoints. Consider adding Spring Security or set 'management.security.enabled' to false.");
        }
    }

    private static class AuthoritiesValidator {
        private AuthoritiesValidator() {
        }

        private boolean hasAuthority(String role) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                for (GrantedAuthority authority : authentication.getAuthorities()) {
                    if (!authority.getAuthority().equals(role)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

