/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.producers;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;

public final class SingleProducer<T>
extends AtomicBoolean
implements Producer {
    private static final long serialVersionUID = -3353584923995471404L;
    final Subscriber<? super T> child;
    final T value;

    public SingleProducer(Subscriber<? super T> child, T value) {
        this.child = child;
        this.value = value;
    }

    @Override
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n == 0L) {
            return;
        }
        if (this.compareAndSet(false, true)) {
            Subscriber<T> c = this.child;
            T v = this.value;
            if (c.isUnsubscribed()) {
                return;
            }
            try {
                c.onNext(v);
            }
            catch (Throwable e) {
                Exceptions.throwOrReport(e, c, v);
                return;
            }
            if (c.isUnsubscribed()) {
                return;
            }
            c.onCompleted();
        }
    }
}

