/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.rx;

import org.springframework.web.context.request.async.DeferredResult;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class DeferredResultSubscriber<T>
extends Subscriber<T>
implements Runnable {
    private final DeferredResult<T> deferredResult;
    private final Subscription subscription;
    private boolean completed;

    public DeferredResultSubscriber(Observable<T> observable, DeferredResult<T> deferredResult) {
        this.deferredResult = deferredResult;
        this.deferredResult.onTimeout((Runnable)this);
        this.deferredResult.onCompletion((Runnable)this);
        this.subscription = observable.subscribe((Subscriber)this);
    }

    public void onNext(T value) {
        if (!this.completed) {
            this.deferredResult.setResult(value);
        }
    }

    public void onError(Throwable e) {
        this.deferredResult.setErrorResult((Object)e);
    }

    public void onCompleted() {
        this.completed = true;
    }

    @Override
    public void run() {
        this.subscription.unsubscribe();
    }
}

