/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.foundation.common.utils.ResourceUtil;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class ConsumerProviderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerProviderManager.class);
    private final OpenAPIRegistryManager openAPIRegistryManager;
    private final Environment environment;

    public ConsumerProviderManager(Environment environment, OpenAPIRegistryManager openAPIRegistryManager) {
        this.environment = environment;
        this.openAPIRegistryManager = openAPIRegistryManager;
    }

    public void init() throws Exception {
        this.registerSwaggerFromApplications();
        this.registerSwaggerFromMicroservices();
    }

    private void registerSwaggerFromApplications() {
        try {
            List resourceUris = ResourceUtil.findResourcesBySuffix((String)"applications", (String)".yaml");
            for (URI uri : resourceUris) {
                String path = uri.toURL().getPath();
                String[] segments = path.split("/");
                if (segments.length < 4 || !"applications".equals(segments[segments.length - 4])) continue;
                this.openAPIRegistryManager.registerOpenAPI(segments[segments.length - 3], segments[segments.length - 2], segments[segments.length - 1].substring(0, segments[segments.length - 1].indexOf(".yaml")), SwaggerUtils.parseAndValidateSwagger((URL)uri.toURL()));
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Load schema ids failed from applications. {}.", (Object)e.getMessage());
        }
    }

    private void registerSwaggerFromMicroservices() {
        try {
            List resourceUris = ResourceUtil.findResourcesBySuffix((String)"microservices", (String)".yaml");
            for (URI uri : resourceUris) {
                String path = uri.toURL().getPath();
                String[] segments = path.split("/");
                if (segments.length < 3 || !"microservices".equals(segments[segments.length - 3])) continue;
                this.openAPIRegistryManager.registerOpenAPI(BootStrapProperties.readApplication((Environment)this.environment), segments[segments.length - 2], segments[segments.length - 1].substring(0, segments[segments.length - 1].indexOf(".yaml")), SwaggerUtils.parseAndValidateSwagger((URL)uri.toURL()));
            }
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Load schema ids failed from microservices. {}.", (Object)e.getMessage());
        }
    }
}

