/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MicroserviceInstanceCache {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceInstanceCache.class);
    private static final Cache<String, DiscoveryInstance> instances = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private final DiscoveryManager discoveryManager;

    public MicroserviceInstanceCache(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    public DiscoveryInstance getOrCreate(String application, String serviceName) {
        try {
            String key = String.format("%s@%s", application, serviceName);
            return (DiscoveryInstance)instances.get((Object)key, () -> {
                VersionedCache instances = this.discoveryManager.getOrCreateVersionedCache(application, serviceName);
                List statefulDiscoveryInstances = (List)instances.data();
                if (CollectionUtils.isEmpty((Collection)statefulDiscoveryInstances)) {
                    throw new IllegalArgumentException("instance id not exists.");
                }
                return (DiscoveryInstance)statefulDiscoveryInstances.get(0);
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.error("get microservice instance from cache failed, {}, {}", (Object)String.format("%s@%s", application, serviceName), (Object)e.getMessage());
            return null;
        }
    }
}

