/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.config.nacos.NacosConfig;
import org.apache.servicecomb.config.nacos.NacosDynamicPropertiesSource;
import org.apache.servicecomb.config.parser.Parser;
import org.springframework.core.env.Environment;

public class NacosClient {
    private final NacosDynamicPropertiesSource.UpdateHandler updateHandler;
    private final NacosConfig nacosConfig;
    private final Environment environment;
    private final Object lock = new Object();
    private Map<String, Object> application = new HashMap<String, Object>();
    private Map<String, Object> service = new HashMap<String, Object>();
    private Map<String, Object> version = new HashMap<String, Object>();
    private Map<String, Object> profile = new HashMap<String, Object>();
    private Map<String, Object> custom = new HashMap<String, Object>();
    private Map<String, Object> allLast = new HashMap<String, Object>();

    public NacosClient(NacosDynamicPropertiesSource.UpdateHandler updateHandler, Environment environment) {
        this.updateHandler = updateHandler;
        this.nacosConfig = new NacosConfig(environment);
        this.environment = environment;
    }

    public void refreshNacosConfig() throws NacosException {
        Properties properties = NacosClient.nacosProperties(this.environment, this.nacosConfig);
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        this.addApplicationConfig(configService);
        this.addServiceConfig(configService);
        this.addVersionConfig(configService);
        this.addProfileConfig(configService);
        this.addCustomConfig(configService);
        this.refreshConfigItems();
    }

    private void addApplicationConfig(ConfigService configService) throws NacosException {
        String content = configService.getConfig(BootStrapProperties.readApplication((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), 5000L);
        this.processApplicationConfig(content);
        configService.addListener(BootStrapProperties.readApplication((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), new Listener(){

            public void receiveConfigInfo(String configInfo) {
                NacosClient.this.processApplicationConfig(configInfo);
                NacosClient.this.refreshConfigItems();
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void processApplicationConfig(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.application = new HashMap<String, Object>();
            return;
        }
        Parser contentParser = Parser.findParser((String)"yaml");
        this.application = contentParser.parse(content, "", false);
    }

    private void addServiceConfig(ConfigService configService) throws NacosException {
        String content = configService.getConfig(BootStrapProperties.readServiceName((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), 5000L);
        this.processServiceConfig(content);
        configService.addListener(BootStrapProperties.readServiceName((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), new Listener(){

            public void receiveConfigInfo(String configInfo) {
                NacosClient.this.processServiceConfig(configInfo);
                NacosClient.this.refreshConfigItems();
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void processServiceConfig(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.service = new HashMap<String, Object>();
            return;
        }
        Parser contentParser = Parser.findParser((String)"yaml");
        this.service = contentParser.parse(content, "", false);
    }

    private void addVersionConfig(ConfigService configService) throws NacosException {
        String content = configService.getConfig(BootStrapProperties.readServiceName((Environment)this.environment) + "-" + BootStrapProperties.readServiceVersion((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), 5000L);
        this.processVersionConfig(content);
        configService.addListener(BootStrapProperties.readServiceName((Environment)this.environment) + "-" + BootStrapProperties.readServiceVersion((Environment)this.environment), BootStrapProperties.readApplication((Environment)this.environment), new Listener(){

            public void receiveConfigInfo(String configInfo) {
                NacosClient.this.processVersionConfig(configInfo);
                NacosClient.this.refreshConfigItems();
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void processVersionConfig(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.version = new HashMap<String, Object>();
            return;
        }
        Parser contentParser = Parser.findParser((String)"yaml");
        this.version = contentParser.parse(content, "", false);
    }

    private void addProfileConfig(ConfigService configService) throws NacosException {
        String profile = this.environment.getProperty("spring.profiles.active");
        if (StringUtils.isEmpty((CharSequence)profile)) {
            return;
        }
        String content = configService.getConfig(BootStrapProperties.readServiceName((Environment)this.environment) + "-" + profile, BootStrapProperties.readApplication((Environment)this.environment), 5000L);
        this.processProfileConfig(content);
        configService.addListener(BootStrapProperties.readServiceName((Environment)this.environment) + "-" + profile, BootStrapProperties.readApplication((Environment)this.environment), new Listener(){

            public void receiveConfigInfo(String configInfo) {
                NacosClient.this.processProfileConfig(configInfo);
                NacosClient.this.refreshConfigItems();
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void processProfileConfig(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.profile = new HashMap<String, Object>();
            return;
        }
        Parser contentParser = Parser.findParser((String)"yaml");
        this.profile = contentParser.parse(content, "", false);
    }

    private void addCustomConfig(ConfigService configService) throws NacosException {
        if (StringUtils.isEmpty((CharSequence)this.nacosConfig.getDataId()) || StringUtils.isEmpty((CharSequence)this.nacosConfig.getGroup())) {
            return;
        }
        String content = configService.getConfig(this.nacosConfig.getDataId(), this.nacosConfig.getGroup(), 5000L);
        this.processCustomConfig(content);
        configService.addListener(this.nacosConfig.getDataId(), this.nacosConfig.getGroup(), new Listener(){

            public void receiveConfigInfo(String configInfo) {
                NacosClient.this.processCustomConfig(configInfo);
                NacosClient.this.refreshConfigItems();
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void processCustomConfig(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            this.custom = new HashMap<String, Object>();
            return;
        }
        Parser contentParser = Parser.findParser((String)this.nacosConfig.getContentType());
        String keyPrefix = this.nacosConfig.getGroup() + "." + this.nacosConfig.getDataId();
        this.custom = contentParser.parse(content, keyPrefix, this.nacosConfig.getAddPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfigItems() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            all.putAll(this.application);
            all.putAll(this.service);
            all.putAll(this.version);
            all.putAll(this.profile);
            all.putAll(this.custom);
            this.updateHandler.handle(all, this.allLast);
            this.allLast = all;
        }
    }

    private static Properties nacosProperties(Environment environment, NacosConfig nacosConfig) {
        Properties properties = new Properties();
        properties.put("namespace", BootStrapProperties.readServiceEnvironment((Environment)environment));
        properties.put("serverAddr", nacosConfig.getServerAddr());
        if (nacosConfig.getUsername() != null) {
            properties.put("username", nacosConfig.getUsername());
        }
        if (nacosConfig.getPassword() != null) {
            properties.put("password", nacosConfig.getPassword());
        }
        if (nacosConfig.getAccessKey() != null) {
            properties.put("accessKey", nacosConfig.getAccessKey());
        }
        if (nacosConfig.getSecretKey() != null) {
            properties.put("secretKey", nacosConfig.getSecretKey());
        }
        return properties;
    }
}

