/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.publish;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MeasurementNode
implements Comparable<MeasurementNode> {
    private final String name;
    private final Meter.Id id;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private Map<String, MeasurementNode> children;

    public MeasurementNode(String name, Meter.Id id, Map<String, MeasurementNode> children) {
        this.name = name;
        this.id = id;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public Meter.Id getId() {
        return this.id;
    }

    public Map<String, MeasurementNode> getChildren() {
        return this.children;
    }

    public MeasurementNode findChild(String childName) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(childName);
    }

    public MeasurementNode findChild(String ... childNames) {
        MeasurementNode node = this;
        for (String childName : childNames) {
            if (node == null) {
                return null;
            }
            node = node.findChild(childName);
        }
        return node;
    }

    public MeasurementNode addChild(String childName, Meter.Id id, Measurement measurement) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, MeasurementNode>();
        }
        MeasurementNode node = this.children.computeIfAbsent(childName, name -> new MeasurementNode((String)name, id, null));
        if (measurement != null) {
            node.addMeasurement(measurement);
        }
        return node;
    }

    public List<Measurement> getMeasurements() {
        return this.measurements;
    }

    public void addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
    }

    public double summary() {
        double result = 0.0;
        for (Measurement measurement : this.measurements) {
            result += measurement.getValue();
        }
        return result;
    }

    @Override
    public int compareTo(MeasurementNode o) {
        return this.name.compareTo(o.name);
    }
}

