/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectProperty;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;

public class OasObjectPropertyLocation {
    private final List<OasObjectProperty> path;

    private OasObjectPropertyLocation(OasObjectProperty path) {
        this(Collections.singletonList(path));
    }

    private OasObjectPropertyLocation(List<OasObjectProperty> path) {
        this.path = Collections.unmodifiableList(path);
    }

    public static OasObjectPropertyLocation root() {
        return new OasObjectPropertyLocation(new OasObjectProperty(OasObjectType.OPENAPI, "$"));
    }

    public OasObjectPropertyLocation property(String propertyName, OasObjectType propertyType) {
        ArrayList<OasObjectProperty> oasObjectProperties = new ArrayList<OasObjectProperty>(this.path);
        oasObjectProperties.add(new OasObjectProperty(propertyType, propertyName));
        return new OasObjectPropertyLocation(oasObjectProperties);
    }

    public OasObjectPropertyLocation property(String propertyName) {
        ArrayList<OasObjectProperty> oasObjectProperties = new ArrayList<OasObjectProperty>(this.path);
        oasObjectProperties.add(new OasObjectProperty(propertyName));
        return new OasObjectPropertyLocation(oasObjectProperties);
    }

    public List<OasObjectProperty> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    @JsonIgnore
    public OasObjectProperty getParent() {
        if (this.path.size() <= 1) {
            return null;
        }
        return this.path.get(this.path.size() - 2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OasObjectPropertyLocation that = (OasObjectPropertyLocation)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return new StringJoiner(", ", OasObjectPropertyLocation.class.getSimpleName() + "[", "]").add("path=" + this.path).toString();
    }

    public static String toPathString(OasObjectPropertyLocation location) {
        if (location == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<OasObjectProperty> path = location.getPath();
        for (OasObjectProperty property : path) {
            sb.append(property.getName()).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

