/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.skeleton.responses;

import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.ResponseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.ResponsesValidator;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public class ResponsesResponsesValidator
implements ResponsesValidator {
    private final List<ResponseValidator> responseValidators;

    public ResponsesResponsesValidator(List<ResponseValidator> responseValidators) {
        this.responseValidators = responseValidators;
    }

    @Override
    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, ApiResponses oasObject) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (Map.Entry entry : oasObject.entrySet()) {
            String statusCode = (String)entry.getKey();
            ApiResponse response = (ApiResponse)entry.getValue();
            OasObjectPropertyLocation responseLoc = location.property(statusCode, OasObjectType.RESPONSE);
            violations.addAll(OasObjectValidatorUtils.doValidateProperty(context, responseLoc, response, this.responseValidators));
        }
        return violations;
    }
}

