/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.generator.annotation.MethodAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;

public class ApiResponseMethodAnnotationProcessor
implements MethodAnnotationProcessor<io.swagger.v3.oas.annotations.responses.ApiResponse, OperationContext> {
    @Override
    public void process(io.swagger.v3.oas.annotations.responses.ApiResponse response, OperationContext context) {
        ApiResponse apiResponse = new ApiResponse();
        io.swagger.v3.oas.annotations.media.Content[] contentAnnotations = response.content();
        Optional.ofNullable(contentAnnotations).ifPresent(contents -> {
            for (io.swagger.v3.oas.annotations.media.Content contentAnnotation : contents) {
                Content content = new Content();
                MediaType mediaType = new MediaType();
                content.addMediaType(contentAnnotation.mediaType(), mediaType);
                apiResponse.setContent(content);
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)response.description())) {
            apiResponse.setDescription(response.description());
        } else {
            apiResponse.description("OK");
        }
        io.swagger.v3.oas.annotations.headers.Header[] headersAnnotation = response.headers();
        Optional.ofNullable(headersAnnotation).ifPresent(headers -> {
            for (io.swagger.v3.oas.annotations.headers.Header headerAnnotation : headers) {
                Header header = new Header();
                header.description(headerAnnotation.description());
                header.deprecated(Boolean.valueOf(headerAnnotation.deprecated()));
                apiResponse.addHeaderObject(headerAnnotation.name(), header);
            }
        });
        context.addResponse(response.responseCode(), apiResponse);
    }
}

