/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.common;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.servicecomb.toolkit.common.CompareAlgorithm;
import org.apache.servicecomb.toolkit.common.Comparison;
import org.apache.servicecomb.toolkit.common.MyersAlgorithm;
import org.apache.servicecomb.toolkit.common.SplitDiffFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContractComparator.class);
    private CompareAlgorithm algorithm;
    private String source;
    private String dest;
    private List<Comparison> comparisonList;

    public ContractComparator(String source, String dest) {
        this(source, dest, new MyersAlgorithm());
    }

    public ContractComparator(String source, String dest, CompareAlgorithm algorithm) {
        this.source = source;
        this.dest = dest;
        this.algorithm = algorithm;
        this.comparisonList = this.compare();
    }

    public void setAlgorithm(CompareAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public CompareAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public List<Comparison> compare() {
        return this.algorithm.compare(this.source, this.dest);
    }

    public boolean equals() {
        return this.comparisonList.size() <= 0;
    }

    public void splitPrintToScreen() {
        this.splitPrint(System.out);
    }

    public void splitPrint(OutputStream outputStream) {
        try {
            new SplitDiffFormatter(outputStream).format(this.comparisonList, this.source, this.dest);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

