/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.aries.spifly.BundleDescriptor;
import org.apache.aries.spifly.ConsumerBundleTrackerCustomizer;
import org.apache.aries.spifly.ConsumerHeaderProcessor;
import org.apache.aries.spifly.ConsumerRestriction;
import org.apache.aries.spifly.Pair;
import org.apache.aries.spifly.ProviderBundleTrackerCustomizer;
import org.apache.aries.spifly.WeavingData;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseActivator
implements BundleActivator {
    private static final Set<WeavingData> NON_WOVEN_BUNDLE = Collections.emptySet();
    public static BaseActivator activator;
    private BundleContext bundleContext;
    private LogServiceTracker logServiceTracker;
    private List<LogService> logServices = new CopyOnWriteArrayList<LogService>();
    private BundleTracker consumerBundleTracker;
    private BundleTracker providerBundleTracker;
    private final ConcurrentMap<Bundle, Set<WeavingData>> bundleWeavingData = new ConcurrentHashMap<Bundle, Set<WeavingData>>();
    private final ConcurrentMap<String, SortedMap<Long, Pair<Bundle, Map<String, Object>>>> registeredProviders = new ConcurrentHashMap<String, SortedMap<Long, Pair<Bundle, Map<String, Object>>>>();
    private final ConcurrentMap<Bundle, Map<ConsumerRestriction, List<BundleDescriptor>>> consumerRestrictions = new ConcurrentHashMap<Bundle, Map<ConsumerRestriction, List<BundleDescriptor>>>();

    public synchronized void start(BundleContext context, String consumerHeaderName) throws Exception {
        this.bundleContext = context;
        this.logServiceTracker = new LogServiceTracker(context);
        this.logServiceTracker.open();
        this.providerBundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)new ProviderBundleTrackerCustomizer(this, context.getBundle()));
        this.providerBundleTracker.open();
        this.consumerBundleTracker = new BundleTracker(context, 46, (BundleTrackerCustomizer)new ConsumerBundleTrackerCustomizer(this, consumerHeaderName));
        this.consumerBundleTracker.open();
        for (Bundle bundle : context.getBundles()) {
            this.addConsumerWeavingData(bundle, consumerHeaderName);
        }
        activator = this;
    }

    public void addConsumerWeavingData(Bundle bundle, String consumerHeaderName) throws Exception {
        if (this.bundleWeavingData.containsKey(bundle)) {
            return;
        }
        Object consumerHeader = bundle.getHeaders().get(consumerHeaderName);
        if (consumerHeader == null) {
            consumerHeaderName = "Require-Capability";
            consumerHeader = bundle.getHeaders().get(consumerHeaderName);
        }
        if (consumerHeader instanceof String) {
            Set<WeavingData> wd = ConsumerHeaderProcessor.processHeader(consumerHeaderName, (String)consumerHeader);
            this.bundleWeavingData.put(bundle, Collections.unmodifiableSet(wd));
            for (WeavingData w : wd) {
                this.registerConsumerBundle(bundle, w.getArgRestrictions(), w.getAllowedBundles());
            }
        } else {
            this.bundleWeavingData.put(bundle, NON_WOVEN_BUNDLE);
        }
    }

    public void removeWeavingData(Bundle bundle) {
        this.bundleWeavingData.remove(bundle);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        activator = null;
        this.consumerBundleTracker.close();
        this.providerBundleTracker.close();
        this.logServiceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String message) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService log : this.logServices) {
                log.log(level, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int level, String message, Throwable th) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService log : this.logServices) {
                log.log(level, message, th);
            }
        }
    }

    public Set<WeavingData> getWeavingData(Bundle b) {
        Set wd = (Set)this.bundleWeavingData.get(b);
        if (wd == null) {
            return null;
        }
        if (wd.size() == 0) {
            return null;
        }
        return wd;
    }

    public void registerProviderBundle(String registrationClassName, Bundle bundle, Map<String, Object> customAttributes) {
        registrationClassName = registrationClassName.trim();
        this.registeredProviders.putIfAbsent(registrationClassName, Collections.synchronizedSortedMap(new TreeMap()));
        SortedMap map = (SortedMap)this.registeredProviders.get(registrationClassName);
        map.put(bundle.getBundleId(), new Pair<Bundle, Map<String, Object>>(bundle, customAttributes));
    }

    public void unregisterProviderBundle(Bundle bundle) {
        for (Map value : this.registeredProviders.values()) {
            Iterator it = value.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!((Bundle)((Pair)entry.getValue()).getLeft()).equals(bundle)) continue;
                it.remove();
            }
        }
    }

    public Collection<Bundle> findProviderBundles(String name) {
        SortedMap map = (SortedMap)this.registeredProviders.get(name);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(map.size());
        for (Pair value : map.values()) {
            bundles.add((Bundle)value.getLeft());
        }
        return bundles;
    }

    public Map<String, Object> getCustomBundleAttributes(String name, Bundle b) {
        SortedMap map = (SortedMap)this.registeredProviders.get(name);
        if (map == null) {
            return Collections.emptyMap();
        }
        Pair data = (Pair)map.get(b.getBundleId());
        if (data == null) {
            return Collections.emptyMap();
        }
        return (Map)data.getRight();
    }

    public void registerConsumerBundle(Bundle consumerBundle, Set<ConsumerRestriction> restrictions, List<BundleDescriptor> allowedBundles) {
        this.consumerRestrictions.putIfAbsent(consumerBundle, new HashMap());
        Map map = (Map)this.consumerRestrictions.get(consumerBundle);
        for (ConsumerRestriction restriction : restrictions) {
            map.put(restriction, allowedBundles);
        }
    }

    public Collection<Bundle> findConsumerRestrictions(Bundle consumer, String className, String methodName, Map<Pair<Integer, String>, String> args) {
        Map restrictions = (Map)this.consumerRestrictions.get(consumer);
        if (restrictions == null) {
            return null;
        }
        for (Map.Entry entry : restrictions.entrySet()) {
            if (!((ConsumerRestriction)entry.getKey()).matches(className, methodName, args)) continue;
            return this.getBundles((List)entry.getValue(), className, methodName, args);
        }
        return Collections.emptySet();
    }

    private Collection<Bundle> getBundles(List<BundleDescriptor> descriptors, String className, String methodName, Map<Pair<Integer, String>, String> args) {
        if (descriptors == null) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle b : this.bundleContext.getBundles()) {
            for (BundleDescriptor desc : descriptors) {
                if (desc.getBundleID() != -1L) {
                    if (b.getBundleId() != desc.getBundleID()) continue;
                    bundles.add(b);
                    continue;
                }
                if (desc.getFilter() != null) {
                    String type;
                    Hashtable<String, Object> d = new Hashtable<String, Object>();
                    if (ServiceLoader.class.getName().equals(className) && "load".equals(methodName) && (type = args.get(new Pair<Integer, String>(0, Class.class.getName()))) != null) {
                        d.put("osgi.serviceloader", type);
                        d.putAll(this.getCustomBundleAttributes(type, b));
                    }
                    if (!desc.getFilter().match(d)) continue;
                    bundles.add(b);
                    continue;
                }
                if (!b.getSymbolicName().equals(desc.getSymbolicName()) || desc.getVersion() != null && !b.getVersion().equals((Object)desc.getVersion())) continue;
                bundles.add(b);
            }
        }
        return bundles;
    }

    private class LogServiceTracker
    extends ServiceTracker {
        public LogServiceTracker(BundleContext context) {
            super(context, LogService.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Object svc = super.addingService(reference);
            if (svc instanceof LogService) {
                BaseActivator.this.logServices.add((LogService)svc);
            }
            return svc;
        }

        public void removedService(ServiceReference reference, Object service) {
            BaseActivator.this.logServices.remove(service);
        }
    }
}

