/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.activemq.wireformat.WireFormatFactory;

public class AmqpWireFormatFactory
implements WireFormatFactory {
    private long maxFrameSize = Long.MAX_VALUE;
    private int maxAmqpFrameSize = -1;
    private int idelTimeout = 30000;
    private int producerCredit = 1000;
    private String transformer = "native";
    private boolean allowNonSaslConnections = false;

    @Override
    public WireFormat createWireFormat() {
        AmqpWireFormat wireFormat = new AmqpWireFormat();
        wireFormat.setMaxFrameSize(this.getMaxFrameSize());
        wireFormat.setMaxAmqpFrameSize(this.getMaxAmqpFrameSize());
        wireFormat.setIdleTimeout(this.getIdelTimeout());
        wireFormat.setProducerCredit(this.getProducerCredit());
        wireFormat.setTransformer(this.getTransformer());
        wireFormat.setAllowNonSaslConnections(this.isAllowNonSaslConnections());
        return wireFormat;
    }

    public int getMaxAmqpFrameSize() {
        return this.maxAmqpFrameSize;
    }

    public void setMaxAmqpFrameSize(int maxAmqpFrameSize) {
        this.maxAmqpFrameSize = maxAmqpFrameSize;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public int getIdelTimeout() {
        return this.idelTimeout;
    }

    public void setIdelTimeout(int idelTimeout) {
        this.idelTimeout = idelTimeout;
    }

    public int getProducerCredit() {
        return this.producerCredit;
    }

    public void setProducerCredit(int producerCredit) {
        this.producerCredit = producerCredit;
    }

    public String getTransformer() {
        return this.transformer;
    }

    public void setTransformer(String transformer) {
        this.transformer = transformer;
    }

    public boolean isAllowNonSaslConnections() {
        return this.allowNonSaslConnections;
    }

    public void setAllowNonSaslConnections(boolean allowNonSaslConnections) {
        this.allowNonSaslConnections = allowNonSaslConnections;
    }
}

